#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    g_rcmds.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_RCMDS
#
rcmd_fields = ['RCMD','CMDNAME','EXT_FLAG']
param_fields = ['RCMD','CPNAME','CPVAL','CPTYPE','SEQ_NUM']

_insert_rcmd = """
insert into g_rcmds (RCMD,CMDNAME,EXT_FLAG,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s)
"""
_insert_param = """
insert into g_params (RCMD,CPNAME,CPVAL,CPTYPE,SEQ_NUM,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s)
"""

def ins_rcmds(cn, filename):
    reader = csv.DictReader(file(filename), rcmd_fields)

    cn.execute("delete from g_rcmds");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['RCMD']) > 0:
            cu.execute(_insert_rcmd, (row['RCMD'],
                                      row['CMDNAME'],
                                      row['EXT_FLAG'],
                                         "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def ins_params(cn, filename):
    reader = csv.DictReader(file(filename), param_fields)

    cn.execute("delete from g_params");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['RCMD']) > 0:
            cu.execute(_insert_param, (row['RCMD'],
                                       row['CPNAME'],
                                       row['CPVAL'],
                                       row['CPTYPE'],
                                       row['SEQ_NUM'],
                                         "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_rcmds(cn, csvdir + os.sep + "rcmds.csv")
    ins_params(cn, csvdir + os.sep + "params.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_rcmds(db, csvdir + os.sep + "rcmds.csv")
    ins_params(db, csvdir + os.sep + "params.csv")
    #
    db.close()

#
def usage():
    print("g_rcmds [-f <dbname>]");


def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hf:v", ["help", "file="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem'
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-f", "--file"):
            output = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)

if __name__ == "__main__":
    main()

