#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    g_event.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import csv
import sqlite, pdo

#
# G_EVENT
#
event_fields = ['CEID','CENAME','SVC_NAME','ENABLED','CATEGORY','KEY_ITEM',
                'ACTION']
evtrpt_fields = ['CEID','RPTID','SEQ_NUM','RPTNAME']
report_fields = ['RPTID','RPTNAME']
rptdata_fields = ['RPTID','VID','SEQ_NUM','VARNAME']

_insert_event = """
insert into g_event (CEID,CENAME,SVC_NAME,ENABLED,CATEGORY,KEY_ITEM,ACTION,\
UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s, %s, %s, %s)
"""
_insert_evtrpt = """
insert into g_evtrpt (CEID,RPTID,SEQ_NUM,RPTNAME,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s)
"""
_insert_report = """
insert into g_report (RPTID,RPTNAME,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s)
"""
_insert_rptdata = """
insert into g_rptdata (RPTID,VID,SEQ_NUM,VARNAME,UPD_DATE,UPD_NAME)
values (%s, %s, %s, %s, %s, %s)
"""

def ins_event(cn, filename):
    reader = csv.DictReader(file(filename), event_fields)

    cn.execute("delete from g_event");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['CEID']) > 0:
            if len(row['ENABLED']) == 0:
                row['ENABLED'] = 'Y'
            cn.execute(_insert_event, (row['CEID'],
                                       row['CENAME'],
                                       row['SVC_NAME'],
                                       row['ENABLED'],
                                       row['CATEGORY'],
                                       row['KEY_ITEM'],
                                       row['ACTION'],
                                        "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def ins_evtrpt(cn, filename):
    reader = csv.DictReader(file(filename), evtrpt_fields)

    cn.execute("delete from g_evtrpt");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['CEID']) > 0:
            cn.execute(_insert_evtrpt, (row['CEID'],
                                        row['RPTID'],
                                        row['SEQ_NUM'],
                                        row['RPTNAME'],
                                        "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def ins_report(cn, filename):
    reader = csv.DictReader(file(filename), report_fields)

    cn.execute("delete from g_report");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['RPTID']) > 0:
            cn.execute(_insert_report, (row['RPTID'],
                                        row['RPTNAME'],
                                        "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break

#
def ins_rptdata(cn, filename):
    reader = csv.DictReader(file(filename), rptdata_fields)

    cn.execute("delete from g_rptdata");
    row = reader.next()       # skip title's row
    row = reader.next()
    while len(row) > 0:
        if len(row['RPTID']) > 0:
            cn.execute(_insert_rptdata, (row['RPTID'],
                                         row['VID'],
                                         row['SEQ_NUM'],
                                         row['VARNAME'],
                                         "", ""))
        try:
            row = reader.next()
        except StopIteration:
            break
    #

#
def to_sqlite(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    outfile = dirname + os.sep + output + ".edb"
    cx = sqlite.connect(outfile)
    cn = cx.cursor()
    #
    ins_event(cn, csvdir + os.sep + "event.csv")
    ins_evtrpt(cn, csvdir + os.sep + "evtrpt.csv")
    ins_report(cn, csvdir + os.sep + "report.csv")
    ins_rptdata(cn, csvdir + os.sep + "rptdata.csv")
    #
    cx.commit()
    cx.close()

#
def to_mysql(output, dirname):
    csvdir = dirname + os.sep + 'csvfiles'
    dsn = "Module=MySQLdb;User=%s;Passwd=%s;DB=%s" % ("jyugem", "jyugem", output)
    db = pdo.connect(dsn)
    #
    ins_event(db, csvdir + os.sep + "event.csv")
    ins_evtrpt(db, csvdir + os.sep + "evtrpt.csv")
    ins_report(db, csvdir + os.sep + "report.csv")
    ins_rptdata(db, csvdir + os.sep + "rptdata.csv")
    #
    db.close()

#
def usage():
    print("g_event [-o <dbname>]");

#
def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "mho:v", ["help", "output="])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
    output = 'gem'
    mysql = False
    verbose = False
    for o, a in opts:
        if o == "-v":
            verbose = True
        if o in ("-o", "--file"):
            output = a
        if o in ("-h", "--help"):
            usage()
            sys.exit()
        if o == "-m":
            mysql = True
    # ...

    dirname = os.getcwd()
    if not mysql:
        to_sqlite(output, dirname)
    else:
        to_mysql(output, dirname)

#
if __name__ == "__main__":
    main()

