#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    gem.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import cmd
import gem

em = gem.EquipmentManager()
em.init()
em.start()
equipment = em.equipment()

eqpname = equipment.variable("EqpName")
mdln    = equipment.variable("EqpModel")
revision = equipment.variable("EqpSoftRev")
eqpname.value = "jyugem"
mdln.value = "bee001"
revision.value = "0.3.1"
print "name = %s, model = %s, softrev = %s" % (eqpname.value, mdln.value, revision.value)

dtnames = ["V", "SV", "ECV", "DVVAL", "PV", "CS", "CV"]

##vartable = equipment.vars()
##q = len(vartable)
##i = 0
##while i < len(vartable):
##    var = vartable[i]
##    dtyp = dtnames[var.datatype()]
##    print "%s(%s) %s: %s= %s" % (var.name(), var.vid(), dtyp, var.sml(), var.value)
##    i += 1

##evtable = equipment.events()
##q = len(evtable)
##i = 0
##while i < len(evtable):
##    evt = evtable[i]
##    print "%s(%s): %s %s %s" % (evt.name(), evt.ceid(), evt.enabled, evt.svcname())
##    i += 1

class Console(cmd.Cmd):
    prompt = '[JYUGEM] '
    def help_stop(self):
        print "stop: terminates the command loops"
    def do_stop(self, rest):
        em.stop()
        return 1

    def help_variable(self):
        print "variable: get/set value of variable"
    def do_variable(self, rest):
        param = rest.split()
        if len(param) < 1:
            print "need variable name"
        else:
            var = equipment.variable(param[0])
        if len(param) == 2:
            var.value = param[1]
        else:
            dtyp = dtnames[var.datatype()]
            print "%s(%s): %s= %s" % (var.vid(), dtyp, var.sml(), var.value)

    def help_config(self):
        print "config: get value of configuration"
    def do_config(self, rest):
        param = rest.split()
        if len(param) < 1:
            print "need parameter name"
        else:
            print equipment.config(param[0])

if __name__ == '__main__':
    Console().cmdloop()
