/* $Id: SECSManager.java,v 1.5 2004/08/14 14:48:43 fukasawa Exp $ */

/**
 *  @file    SECSManager.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.util.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.tree.*;

import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;

public class SECSManager extends Thread {
    static SECSManager m_instance = null;

    SECSConfigurator m_configure;
    SECSResponder    m_responder;
    SECSDriver       m_driver;
    XmlMessage       m_default;
    MessageBox       m_msgbox;

    public static SECSManager getInstance() {
        if (m_instance == null) {
             try {
                 m_instance = new SECSManager();
             } catch (Exception e) {
                 e.printStackTrace();
             }
             m_instance.open();
        }
        return m_instance;
    }

    protected SECSManager() {
        m_msgbox = new MessageBox();
        m_default  = new XmlMessage();
        m_configure = new SECSConfigurator();
        m_driver = new SECSDriver();
    }

    protected int open() {
        m_configure.configure();   // must first
        m_default.open(m_configure.getMessageFile());
        if (m_configure.isHSMS()) {
            m_driver.open(m_configure.getSecsXmlFile(),
                          m_configure.getDeviceID(), m_configure.isEquipment(),
                          m_configure.getIPAddress(), m_configure.getPort(),
                          m_configure.getMode());
        } else {
            m_driver.open(m_configure.getSecsXmlFile(),
                          m_configure.getDeviceID(), m_configure.isEquipment(),
                          m_configure.getBaudrate(), m_configure.getPort());
        }
        m_responder = new SECSResponder(this);
        m_responder.start();
        return 0;
    }

    public SECSDriver    driver()     { return m_driver; }
    public SECSResponder responder()  { return m_responder; }
    public MessageBox    messageBox() { return m_msgbox; }
    public XmlMessage    getDefaultMessages() { return m_default; }

    public DefaultListModel getSFList() {
        String sfname;
        DefaultListModel result = new DefaultListModel();

        Iterator iter = m_default.values().iterator();
        while (iter.hasNext()) {
            Node msgroot = (Node)iter.next();
            NamedNodeMap namedmap = msgroot.getAttributes();
            Node attr = namedmap.getNamedItem("name");
            if (attr == null) {
                attr = namedmap.getNamedItem("sf");
            }
            sfname = attr.getNodeValue();
            result.addElement(sfname);
        }
        return result;
    }

    public int send(SECSMessage msg) {
        return m_driver.send(msg);
    }

    public int send(String sfname) {
        try {
            // Make message from xml
            SECSMessage msg = m_default.makeMessage(sfname);
            if (msg == null) {
                return -1;
            }
            return m_driver.send(msg);
        } catch (SECSException e) {
            return -1;
        }
    }

    public SECSMessage receive() {
        return m_driver.receive();
    }

    public void run() {
        while (true) {
            try {
                sleep((int)((Math.random() % 100) * 100));
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        SECSManager manager = SECSManager.getInstance();
        manager.start();
    }
}

