/* $Id: TestCaseParser.java,v 1.5 2004/08/14 14:48:42 fukasawa Exp $ */

/**
 *  @file    TestCaseParser.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.jsunit.tfw;

import java.util.*;
import java.lang.*;
import java.io.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import junit.framework.*;
import com.jyugem.secs.*;

public class TestCaseParser {

    public static SECSTestCase parse(Node node) throws SAXException {
        String testname = null;
        String description = null;
        int sec = -1;           // default is forever
        int interval = -1;      // default is not sleep

        NamedNodeMap attrs = node.getAttributes();
        int attrCount = (attrs != null) ? attrs.getLength() : 0;
        for (int j = 0; j < attrCount; j++) {
            Node attr = attrs.item(j);
            if (attr.getNodeName().equals("name")) {
                if (testname == null) {
                    testname = attr.getNodeValue();
                }
            } else if (attr.getNodeName().equals("description")) {
                description = attr.getNodeValue();
            } else if (attr.getNodeName().equals("time")) {
                String timeStr = attr.getNodeValue();
                sec = Integer.parseInt(timeStr);
            } else if (attr.getNodeName().equals("interval")) {
                String intervalStr = attr.getNodeValue();
                interval = Integer.parseInt(intervalStr);
            }
        }

        // iterate over children of this node
        NodeList nodes = node.getChildNodes();
        SECSTestCase testcase = null;
        int len = (nodes != null) ? nodes.getLength() : 0;
        for (int i = 0; i < len; i++) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeType() == Node.ELEMENT_NODE) {
                if (childNode.getNodeName().equals("secs:send")) {
                    if (testcase == null) {
                        testcase = new ActiveTestCase(testname);
                    }
                    parseSendElementNode(testcase, childNode);
                } else if (childNode.getNodeName().equals("secs:expects")) {
                    testcase = new PassiveTestCase(testname);
                    parseExpectPair(testcase, childNode);
                } else if (childNode.getNodeName().equals("secs:expect")) {
                    if (testcase == null) {
                        testcase = new PassiveTestCase(testname);
                        testcase.newPair();   // "send" element is nothing
                    }
                    parseExpectElementNode(testcase, childNode);
                }
            }
        }
        if (testcase != null) {
            testcase.setDescription(description);
            if (sec > 0) {        // zero means forever
                testcase.setWatchTime(sec);
            }
            if (interval > 0) {   // zero means not sleep
                testcase.setSleepTime(interval);
            }
        }
        return testcase;
    }

    // Builds the message
    private static void parseExpectElementNode(SECSTestCase test, Node node)
                                        throws SAXException {
        int result = 1;         // default is PASS
        int match = 0;          // default is MATCH
        int pattern = 0;        // default is THIS

        NamedNodeMap attrs = node.getAttributes();
        int attrCount = (attrs != null) ? attrs.getLength() : 0;
        for (int i = 0; i < attrCount; i++) {
            Node attr = attrs.item(i);
            if (attr.getNodeName().equals("pattern")) {
                String resultStr = attr.getNodeValue();
                if (resultStr.equals("THIS")) {
                    pattern = 0;
                } else if (resultStr.equals("RECEIVED")) {
                    pattern = 1;
                } else {
                    throw new SAXException("<secs:testcase> Invalid attribute \"decision\"");
                }
            } else if (attr.getNodeName().equals("compare")) {
                String compStr = attr.getNodeValue();
                if (compStr.equals("MATCH")) {
                    match = 0;
                } else if (compStr.equals("CONTAIN")) {
                    match = 1;
                } else if (compStr.equals("NOT-MATCH")) {
                    match = 2;
                } else if (compStr.equals("NOT-CONTAIN")) {
                    match = 3;
                } else {
                    throw new SAXException("<secs:testcase> Invalid attribute \"compare\"");
                }
            } else if (attr.getNodeName().equals("decision")) {
                String resultStr = attr.getNodeValue();
                if (resultStr.equals("PASS")) {
                    result = 1;
                } else if (resultStr.equals("XPASS")) {
                    result = 2;
                } else if (resultStr.equals("NOP")) {
                    result = 0;
                } else {
                    throw new SAXException("<secs:testcase> Invalid attribute \"decision\"");
                }
            }
        }
        String patternStr = null;
        NodeList nodes = node.getChildNodes();
        int len = (nodes != null) ? nodes.getLength() : 0;
        for (int i = 0; i < len; i++) {
            Node expNode = nodes.item(i);
            if (expNode.getNodeType() == Node.CDATA_SECTION_NODE) {
                patternStr = expNode.getNodeValue();
            }
        }
        if (patternStr == null) {
            for (int i = 0; i < len; i++) {
                Node expNode = nodes.item(i);
                if (expNode.getNodeType() == Node.TEXT_NODE) {
                    patternStr = expNode.getNodeValue();
                }
            }
        }
        test.setLast(patternStr, result, match, pattern);
   }

    private static void parseExpectPair(SECSTestCase test, Node node)
                                        throws SAXException {
        // iterate over children of this node
        NodeList nodes = node.getChildNodes();
        int len = (nodes != null) ? nodes.getLength() : 0;
        for (int i = 0; i < len; i++) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeType() == Node.ELEMENT_NODE &&
                childNode.getNodeName().equals("secs:expair")) {
                insertExpectPairElementNode(test, childNode);
            }
        }
    }

    private static void insertExpectPairElementNode(SECSTestCase test, Node node)
                                        throws SAXException {
        // iterate over children of this node
        NodeList nodes = node.getChildNodes();
        int len = (nodes != null) ? nodes.getLength() : 0;
        if (len > 0) {
            Node childNode;
            if (len > 1) {
                childNode = nodes.item(1);         // first, parse <send> tag
                if (childNode.getNodeType() == Node.ELEMENT_NODE &&
                    childNode.getNodeName().equals("secs:send")) {
                    parseSendElementNode(test, childNode);
                }
            } else {
                test.newPair();
            }
            childNode = nodes.item(0);         // next, parse <expect> tag
            if (childNode.getNodeType() == Node.ELEMENT_NODE &&
                childNode.getNodeName().equals("secs:expect")) {
                parseExpectElementNode(test, childNode);
            }
        }
    }

    // Convert xml to send message.
    public static void parseSendElementNode(SECSTestCase test, Node node)
                                        throws SAXException {
        String sfname = null;
        String sflabel = null;
        String waitStr = "";
        boolean defaultMessage = true;
        NamedNodeMap attrs = node.getAttributes();
        int attrCount = (attrs != null) ? attrs.getLength() : 0;
        for (int i = 0; i < attrCount; i++) {
            Node attr = attrs.item(i);
            if (attr.getNodeName().equals("name")) {
                sflabel = attr.getNodeValue();
            } else if (attr.getNodeName().equals("sf")) {    // Must use "sf" code
                sfname = attr.getNodeValue();
            } else if (attr.getNodeName().equals("wait")) {
                waitStr = attr.getNodeValue();
            } else if (attr.getNodeName().equals("body")) {
                String sourceStr = attr.getNodeValue();
                if (sourceStr.equals("THIS")) {
                    defaultMessage = false;
                } else if (sourceStr.equals("DEFAULT")) {
                    defaultMessage = true;
                }
            }
        }
        if (sfname == null) {
            throw new SAXException("XML Parse error : undefined stream/function");
        }

        if (defaultMessage) {
            test.addPair(sfname, defaultMessage);
        } else {
            test.addPair(sfname, node);
        }
        return ;
    }

}

