/* $Id: PassiveTestCase.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    PassiveTestCase.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.jsunit.tfw;

import org.w3c.dom.Node;
import junit.framework.*;
import com.jyugem.secs.*;

/**
 * SECS Active test.
 *
 */
public class PassiveTestCase extends SECSTestCase {

    public PassiveTestCase(String name) {
        super(name);
        m_pair = new PassiveTestPair();
        m_methodName = "testPassive";
    }

    protected void setUp() {
    }

    public static junit.framework.Test suite() {
        TestSuite suite= new TestSuite();
        suite.addTest(
            new PassiveTestCase("PassiveTestCase") {
                 protected void runTest() { testPassive(); }
            }
        );

        return suite;
    }

    public void addPair(String sf, Node msgNode) {
        m_pair.set(sf, msgNode);
    }
    public void addPair(String sf, boolean defaultMessage) {
        m_pair.set(sf, defaultMessage);
    }

    public void testPassive() {
        SECSMessage msg;
        if (m_delay > 0) {
            msg = m_msgbox.get(m_delay);   // *** Receive response ***
        } else {
            msg = m_msgbox.get();          // *** Receive response ***
        }
        assertNotNull(msg);                // Check timeout.

        SECSMessage xmlmsg = compareMatch(m_description, m_pair, msg);
        if (m_sleep > 0) {
            try {
                Thread.sleep(m_sleep);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (xmlmsg != null) {
            if (msg.isPrimary() && ((msg.number() + 1) == xmlmsg.number())) {
                xmlmsg.transaction(msg.transaction());
            }
            m_manager.send(xmlmsg);
            m_resent = msg.toXMLString();
        } else {
            xmlmsg = m_pair.getMessage(0);
            if (msg.isPrimary() && ((msg.number() + 1) == xmlmsg.number())) {
                xmlmsg.transaction(msg.transaction());
            }
            m_manager.send(xmlmsg);

            fail(m_description, m_pair.getExpect(), msg.toXMLString());
        }
    }

    public String toXmlString() {
        return toXmlString(false);
    }

    // Send and Expect message pair
    public class PassiveTestPair extends TestPair {
        public PassiveTestPair() {
            super();
        }
    }

}
