// $Id: JSUInt4.cpp,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSUInt4.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSUInt4.h"
#include "BS2Array.h"
#include "BS2List.h"

static const char * _className = CLASSPATH "UInteger";

void JSUInt4::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSUInt4::init");

    initClass(jenv, itemClass);

    m_class = m_jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_vget = m_jenv->GetMethodID(m_class, "intValue", "()I");
    ASSERT_METHODID(m_vget, "intValue", "()I");

    m_new = m_jenv->GetMethodID(m_class, "<init>", "(I)V");
    ASSERT_METHODID(m_new, "<init>", "(I)V");

    string argStr = "(Ljava/lang/String;L";
    argStr += _className;
    argStr += ";)V";
    m_item = m_jenv->GetMethodID(itemClass, "<init>", argStr.c_str());
    ASSERT_METHODID(m_item, "<init>", argStr.c_str());
}

// secs value to atom object
jobject JSUInt4::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSUInt4::toObj");
    jobject obj = m_jenv->NewObject(m_class, m_new,
                                    reinterpret_cast<BS2UInt4 *>(atom)->value());
    return obj;
}

// secs value to item object
jobject JSUInt4::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSUInt4::toItemObj");
    jobject obj;
    int format = atom->format();
    if (format & ATOM_ARRAY)
    {
        BS2UInt4Array * arrayAtom = reinterpret_cast<BS2UInt4Array *>(atom);
        int    len = arrayAtom->count();
        UINT * values = arrayAtom->value();
        jobjectArray array = m_jenv->NewObjectArray(len, m_class, NULL);
        BEEAssert(array != NULL);
        for (int i = 0; i < len; i++)
        {
            jobject aObj = m_jenv->NewObject(m_class, m_new,
                                             (jint)(*(values + i)));
            m_jenv->SetObjectArrayElement(array, i, aObj);
        }
        obj = array;
    }
    else
    {
        int     val = reinterpret_cast<BS2UInt4 *>(atom)->value();
        jobject valObj = m_jenv->NewObject(m_class, m_new, (jint)val);
        obj = m_jenv->NewObject(m_itemClass, m_item, itemName, valObj);
    }
    return obj;
}

// jobject to secs value
BS2Atom * JSUInt4::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSUInt4::toAtom");

    BS2Atom * atom;
    if (valObj != NULL)
    {
        jint val = m_jenv->CallIntMethod(valObj, m_vget);
        atom = new BS2UInt4(val);
    }
    else
    {
        atom = new BS2UInt4();
    }
    return atom;
}

// jobject to secs array
BS2Atom * JSUInt4::toArray(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSUInt4::toArray");

    if (valObj == NULL)
    {
        TRACE_ERROR(("Empty member object\n"));
        return NULL;
    }

    jobjectArray array = (jobjectArray)valObj;
    jsize        len    = m_jenv->GetArrayLength(array);
    UINT *       values = new UINT[len];
    for (int i = 0; i < len; i++)
    {
        jobject obj = m_jenv->GetObjectArrayElement(array, i);
        jint    val = m_jenv->CallIntMethod(obj, m_vget);
        *(values + i) = (UINT)val;
    }
    BS2UInt4Array * atom = new BS2UInt4Array();
    atom->add(values, len);
    delete[] values;

    return atom;
}

// jobject to secs list
int JSUInt4::toList(jobject valObj, BS2List * listAtom)
{
    TRACE_FUNCTION(TRL_LOW, "JSUInt4::toList");

    jint len = m_jenv->CallIntMethod(valObj, m_listSize);
    for (int i = 0; i < len; i++)
    {
        jobject mbrObj = m_jenv->CallObjectMethod(valObj, m_listGet, i);
        jint val = m_jenv->CallIntMethod(mbrObj, m_vget);
        BS2Atom * atom = new BS2UInt4((UINT)val);
        listAtom->add(*atom);
        delete atom;
    }
    return 0;
}


