/* $Id: SECSMessage.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    SECSMessage.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.util.*;
import java.io.*;
import javax.swing.tree.*;

//
// SECS Message
//
public class SECSMessage extends DefaultMutableTreeNode {
    // data
    protected int     m_stnum = 0;
    protected String  m_stname;
    protected boolean m_wait = false;
    protected int     m_transactionNum = 0;

    // Constractor
    public SECSMessage(int sfnum) {
        m_stnum = sfnum;
        m_stname = toStreamName(sfnum);
        if ((m_stnum & 1) == 1) {
            m_wait = true;
        }
    }

    public SECSMessage(String sfname) {
        m_stname = sfname;
        m_stnum = toStreamNumber(sfname);
        if ((m_stnum & 1) == 1) {
            m_wait = true;
        }
    }

    public SECSMessage(String sfname, boolean wait, int transNum) {
        m_stname = sfname;
        m_stnum = SECSMessage.toStreamNumber(sfname);
        m_wait = wait;
        m_transactionNum = transNum;
    }

    public String toString() { return m_stname; }
    public String name() { return m_stname; }
    public int number()  { return m_stnum; }
    public int  transaction()   { return m_transactionNum; }
    public void transaction(int num) { m_transactionNum = num; }
    public boolean needReply() { return m_wait; }
    public boolean isPrimary() { return ((m_stnum & 1) == 1); }

    public static String toStreamName(int stnum) {
        String name = "S" + Integer.toString(stnum / 256) +
                      "F" + Integer.toString(stnum % 256);
        return name;
    }

    public static int toStreamNumber(String name) {
        int s_pos = name.indexOf('S');
        int f_pos = name.indexOf('F', s_pos);
        int e_pos = name.indexOf('_', f_pos);
        String ststr = name.substring(s_pos + 1, f_pos);
        String funcstr;
        if (e_pos > 0) {
            funcstr = name.substring(f_pos + 1, e_pos);
        } else {
            funcstr = name.substring(f_pos + 1);
        }
        int num = (Integer.parseInt(ststr) * 256) + Integer.parseInt(funcstr);
        return num;
    }

    public void set(SECSItem item) {
        setUserObject(item);
        setAllowsChildren(false);
    }

    public void set(SECSList list) {
        add(list);
    }

    //
    // Parse message
    //
    public int traverse(SECSParser userParser) {
        userParser.set(this);
        if (getAllowsChildren() == false) {
            SECSItem item = (SECSItem)getUserObject();
            if (item != null) {
                return item.parseItem(1, userParser);
            }
        } else if (getRoot() != null && (! getRoot().isLeaf())) {
            SECSList first = (SECSList)(getRoot().getChildAt(0));
            return first.parseItem(1, userParser);
        }
        return 0;
    }

    public SECSMessage makeResponse() {
        SECSMessage reply = new SECSMessage(toStreamName(m_stnum + 1), false,
                                            m_transactionNum);
        return reply;
    }

    public String toXMLString() {
        SECS2XML xml = new SECS2XML();
        int result = traverse(xml);
        if (result >= 0) {
            String xmlStr = xml.toString();
            return xmlStr;
        }
        return null;
    }

    //
    // Dumper for debug
    //
    public void dump() {
        String waitStr = "\" ";
        if (m_wait) {
            waitStr = "\" wait=\"TRUE\" ";
        }
        System.out.println("<secs:message sf=\"" + m_stname + waitStr +
                           "transaction=\"" + m_transactionNum + "\">");
        if (getUserObject() != null) {
            SECSItem item = (SECSItem)getUserObject();
            item.dump(1);
        } else if (getChildCount() > 0) {
            SECSList first = (SECSList)getChildAt(0);
            first.dump(1);
        }
        System.out.println("</secs:message>");
    }

    //
    // Test main
    //
    public static void main(String[] args) {
        boolean connect = true;

        SECSMessage s1f1 = new SECSMessage("S1F1");
        s1f1.dump();

        SECSMessage s1f2 = new SECSMessage("S1F2");
        SECSItem item1 = new SECSItem("MDLN", "JYUGEM");
        SECSItem item2 = new SECSItem("SOFTREV", "1.0.0");
        SECSList list1 = new SECSList();
        list1.add(item1);
        list1.add(item2);
        s1f2.set(list1);
        s1f2.dump();

        SECSMessage s1f14 = new SECSMessage("S1F14");
        SECSList list = new SECSList();
        byte ack = 0;

        SECSItem item0 = new SECSItem("COMMACK", ack);
        list.add(item0);
        list.add(list1);
        s1f14.set(list);
        s1f14.dump();

        if (connect) {
            SECSDriver jdriver = new SECSDriver();
            jdriver.open("secs.xml", SECSDriver.HSMS);

            SECSMessage primary;
            SECSMessage reply;
            while (true) {
                primary = jdriver.receive();
                primary.dump();
                if (primary.name().equals("S1F1")) {
                    reply = primary.makeResponse();
                    reply.set(list1);
                    reply.dump();
                    jdriver.send(reply);
                } else {
                    reply = primary.makeResponse();
                    reply.dump();
                    jdriver.send(reply);
                }
            }
        }
    }

}
