/* $Id: SECSUnit.java,v 1.5 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    SECSUnit.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package com.jyugem.jsunit.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;
import com.sun.JTreeTable.*;
import com.jyugem.secs.*;
import com.jyugem.jsunit.tfw.*;

public class SECSUnit {
    boolean packFrame = false;
    SECSTestManager mngr;

    // Construct the application
    public SECSUnit() {
        mngr = SECSTestManager.getTestManager();
        SECSFrame frame = new SECSFrame(mngr);
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });

        // Validate frames that have preset sizes
        if (packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }

        // Center the window
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2,
                          (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    // Main method
    public static void main(String[] args) {
        new SECSUnit();
    }
}
