#===============================
# Dxf Class Definition
#===============================
class DL_Extrusion:
	def __init__(self):
		self.direction = [0.0, 0.0, 0.0]
		self.elevation = 0.0

	def setDirection(self, dx, dy, dz):
		self.direction[0] = dx
		self.direction[1] = dy
		self.direction[2] = dz
	def setElevation(self, h):
		self.elevation = h


class DL_Attributes:
	def __init__(self, layer, color, width, linetype):
		self.layer = layer
		self.color = color
		self.width = width
		self.lineType = linetype

# Layer Data.
#
class DL_LayerData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, lName, lFlags):
		#Layer name.
		self.name = lName
		#Layer flags. (1 = frozen, 2 = frozen by default, 4 = locked):
		self.flags = lFlags

#
# Block Data.
#
class DL_BlockData :
	#
	# Conclassor.
	# Parameters: see member variables.

	def __init__(self, bName, bFlags, bbpx, bbpy, bbpz):
		#Block name.
		self.name = bName
		#Block flags. (not used currently):
		self.flags = bFlags
		#X Coordinate of base point.
		self.bpx = bbpx
		#Y Coordinate of base point.
		self.bpy = bbpy
		#Z Coordinate of base point.
		self.bpz = bbpz

#
# Line Type Data.
#
class DL_LineTypeData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, lName, lFlags):
		#Line type name.
		self.name = lName
		#Line type flags.
		self.flags = lFlags

#
# PoData.
#
class DL_PointData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, px=0.0, py=0.0, pz=0.0):
		#X Coordinate of the point.
		self.x = px
		#Y Coordinate of the point.
		self.y = py
		#Z Coordinate of the point.
		self.z = pz

#
# Line Data.
#
class DL_LineData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, lx1, ly1, lz1, lx2, ly2, lz2):
		#X Start coordinate of the point.
		self.x1 = lx1
		#Y Start coordinate of the point.
		self.y1 = ly1
		#Z Start coordinate of the point.
		self.z1 = lz1
		#X End coordinate of the point.
		self.x2 = lx2
		#Y End coordinate of the point.
		self.y2 = ly2
		#Z End coordinate of the point.
		self.z2 = lz2

#
# Arc Data.
#
class DL_ArcData :
	#
	# Conclassor.
	# Parameters: see member variables.

	def __init__(self, acx, acy, acz,
				aRadius,
				aAngle1, aAngle2):
		#X Coordinate of center point.
		self.cx = acx
		#Y Coordinate of center point.
		self.cy = acy
		#Z Coordinate of center point.
		self.cz = acz
		#Radius of arc.
		self.radius = aRadius
		#Startangle of arc in degrees.
		self.angle1 = aAngle1
		#Endangle of arc in degrees.
		self.angle2 = aAngle2



#
# Circle Data.
#
class DL_CircleData :
	#
	# Conclassor.
	# Parameters: see member variables.

	def __init__(self, acx, acy, acz,
				aRadius):
		#X Coordinate of center point.
		self.cx = acx
		#Y Coordinate of center point.
		self.cy = acy
		#Z Coordinate of center point.
		self.cz = acz
		#Radius of arc.
		self.radius = aRadius



#
# Polyline Data.
#
class DL_PolylineData :
	#
	# Conclassor.
	# Parameters: see member variables.

	def __init__(self, pNumber, pMVerteces, pNVerteces, pFlags):
		#Number of vertices in this polyline.
		self.number = pNumber
		#Number of vertices in m direction if polyline is a polygon mesh.
		self.m = pMVerteces
		#Number of vertices in n direction if polyline is a polygon mesh.
		self.n = pNVerteces
		#Flags
		self.flags = pFlags

#
# Vertex Data.
#
class DL_VertexData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, px=0.0, py=0.0, pz=0.0, pBulge=0.0):
		#X Coordinate of the vertex.
		self.x = px
		#Y Coordinate of the vertex.
		self.y = py
		#Z Coordinate of the vertex.
		self.z = pz
		#Bulge of vertex.
		# (The tangent of 1/4 of the arc angle or 0 for lines):
		self.bulge = pBulge

#
# Trace Data.
#
class DL_TraceData :
	def __init__(self):
		self.x = [0.0] * 4
		self.y = [0.0] * 4
		self.z = [0.0] * 4

#
# Solid Data.
#
class DL_SolidData :
	def __init__(self):
		self.x = [0.0] * 4
		self.y = [0.0] * 4
		self.z = [0.0] * 4

#
# Spline Data.
#
class DL_SplineData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, pDegree, pNKnots, pNControl, pFlags):
		#Degree of the spline curve.
		self.degree = pDegree
		#Number of knots.
		self.nKnots = pNKnots
		#Number of control points.
		self.nControl = pNControl
		#Flags
		self.flags = pFlags


#
# Spline knot data.
#
class DL_KnotData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, pk):
		#Knot value.
		self.k = pk

#
# Spline control podata.
#
class DL_ControlPointData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, px, py, pz):
		#X coordinate of the control point.
		self.x = px
		#Y coordinate of the control point.
		self.y = py
		#Z coordinate of the control point.
		self.z = pz

#
# Ellipse Data.
#
class DL_EllipseData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, ecx, ecy, ecz,
				 emx, emy, emz,
				 eRatio,
				 eAngle1, eAngle2):
		#X Coordinate of center point.
		self.cx = ecx
		#Y Coordinate of center point.
		self.cy = ecy
		#Z Coordinate of center point.
		self.cz = ecz
		#X coordinate of the endpoof the major axis.
		self.mx = emx
		#Y coordinate of the endpoof the major axis.
		self.my = emy
		#Z coordinate of the endpoof the major axis.
		self.mz = emz
		#Ratio of minor axis to major axis..
		self.ratio = eRatio
		#Startangle of ellipse in rad.
		self.angle1 = eAngle1
		#Endangle of ellipse in rad.
		self.angle2 = eAngle2

#
# Insert Data.
#
class DL_InsertData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, iName,
				iipx, iipy, iipz,
				isx, isy, isz,
				iAngle,
				iCols, iRows,
				iColSp, iRowSp):
		#Name of the referred block.
		self.name = iName
		#X Coordinate of insertion point.
		self.ipx = iipx
		#Y Coordinate of insertion point.
		self.ipy = iipy
		#Z Coordinate of insertion point.
		self.ipz = iipz
		#X Scale factor.
		self.sx = isx
		#Y Scale factor.
		self.sy = isy
		#Z Scale factor.
		self.sz = isz
		#Rotation angle in rad.
		self.angle = iAngle
		#Number of colums if we insert an array of the block or 1.
		self.cols = iCols
		#Number of rows if we insert an array of the block or 1.
		self.rows = iRows
		#Values for the spacing between cols.
		self.colSp = iColSp
		#Values for the spacing between rows.
		self.rowSp = iRowSp



#
# MText Data.
#
class DL_MTextData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, tipx, tipy, tipz,
				 tHeight, tWidth,
				 tAttachmentPoint,
				 tDrawingDirection,
				 tLineSpacingStyle,
				 tLineSpacingFactor,
				 tText,
				 tStyle,
				 tAngle):
		#X Coordinate of insertion point.
		self.ipx = tipx
		#Y Coordinate of insertion point.
		self.ipy = tipy
		#Z Coordinate of insertion point.
		self.ipz = tipz
		#Text height
		self.height = tHeight
		#Width of the text box.
		self.width = tWidth
		#
		# Attachment point.
		#
		# 1 = Top left, 2 = Top center, 3 = Top right,
		# 4 = Middle left, 5 = Middle center, 6 = Middle right,
		# 7 = Bottom left, 8 = Bottom center, 9 = Bottom right
		self.attachmentPo= tAttachmentPoint
		#
		# Drawing direction.
		#
		# 1 = left to right, 3 = top to bottom, 5 = by style
		self.drawingDirection = tDrawingDirection
		#
		# Line spacing style.
		#
		# 1 = at least, 2 = exact
		self.lineSpacingStyle = tLineSpacingStyle
		#
		# Line spacing factor. 0.25 .. 4.0
		self.lineSpacingFactor = tLineSpacingFactor
		#Text string.
		self.text = tText
		#Style string.
		self.style = tStyle
		#Rotation angle.
		self.angle = tAngle

#
# Text Data.
#
class DL_TextData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, tipx, tipy, tipz,
				tapx, tapy, tapz,
				tHeight, tXScaleFactor,
				tTextGenerationFlags,
				tHJustification,
				tVJustification,
				tText,
				tStyle,
				tAngle):
		#X Coordinate of insertion point.
		self.ipx = tipx
		#Y Coordinate of insertion point.
		self.ipy = tipy
		#Z Coordinate of insertion point.
		self.ipz = tipz
		#X Coordinate of alignment point.
		self.apx = tapx
		#Y Coordinate of alignment point.
		self.apy = tapy
		#Z Coordinate of alignment point.
		self.apz = tapz
		#Text height
		self.height = tHeight
		#Relative X scale factor.
		self.xScaleFactor = tXScaleFactor
		#0 = default, 2 = Backwards, 4 = Upside down
		self.textGenerationFlags = tTextGenerationFlags
		#
		# Horizontal justification.
		#
		# 0 = Left (default), 1 = Center, 2 = Right,
		# 3 = Aligned, 4 = Middle, 5 = Fit
		# For 3, 4, 5 the vertical alignment has to be 0.
		self.hJustification = tHJustification
		#
		# Vertical justification. 
		#
		# 0 = Baseline (default), 1 = Bottom, 2 = Middle, 3= Top
		self.vJustification = tVJustification
		#Text string.
		self.text = tText
		#Style (font).
		self.style = tStyle
		#Rotation angle of dimension text away from default orientation.
		self.angle = tAngle

#
# Generic Dimension Data.
#
class DL_DimensionData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, ddpx, ddpy, ddpz,
					 dmpx, dmpy, dmpz,
					 dType,
					 dAttachmentPoint,
					 dLineSpacingStyle,
					 dLineSpacingFactor,
					 dText,
					 dStyle,
					 dAngle):
		#X Coordinate of definition point.
		self.dpx = ddpx
		#Y Coordinate of definition point.
		self.dpy = ddpy
		#Z Coordinate of definition point.
		self.dpz = ddpz
		#X Coordinate of middle poof the text.
		self.mpx = dmpx
		#Y Coordinate of middle poof the text.
		self.mpy = dmpy
		#Z Coordinate of middle poof the text.
		self.mpz = dmpz
		#
		# Dimension type.
		#
		# 0 Rotated, horizontal, or vertical
		# 1 Aligned
		# 2 Angular
		# 3 Diametric
		# 4 Radius
		# 5 Angular 3-point
		# 6 Ordinate
		# 64Ordinate type. This is a bit value (bit 7)
		#	 used only with integer value 6. If set,	 
		#	 ordinate is X-type if not set, ordinate is 
		#	 Y-type
		# 128 This is a bit value (bit 8) added to the
		#	 other group 70 values if the dimension text 
		#	 has been positioned at a user-defined	 
		#	location rather than at the default location
		self.type = dType
		#
		# Attachment point.
		#
		# 1 = Top left, 2 = Top center, 3 = Top right,
		# 4 = Middle left, 5 = Middle center, 6 = Middle right,
		# 7 = Bottom left, 8 = Bottom center, 9 = Bottom right,
		self.attachmentPo= dAttachmentPoint
		#
		# Line spacing style.
		#
		# 1 = at least, 2 = exact
		self.lineSpacingStyle = dLineSpacingStyle
		#
		# Line spacing factor. 0.25 .. 4.0
		self.lineSpacingFactor = dLineSpacingFactor
		#
		# Text string. 
		#
		# Text string entered explicitly by user or null
		# or "<>" for the actual measurement or " " (one blank space).
		# for supressing the text.
		self.text = dText
		#Dimension style (font name).
		self.style = dStyle
		#
		# Rotation angle of dimension text away from
		# default orientation.
		self.angle = dAngle

#
# Aligned Dimension Data.
#
class DL_DimAlignedData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, depx1, depy1, depz1,
				depx2, depy2, depz2):
		#X Coordinate of Extension po1.
		self.epx1 = depx1
		#Y Coordinate of Extension po1.
		self.epy1 = depy1
		#Z Coordinate of Extension po1.
		self.epz1 = depz1
		#X Coordinate of Extension po2.
		self.epx2 = depx2
		#Y Coordinate of Extension po2.
		self.epy2 = depy2
		#Z Coordinate of Extension po2.
		self.epz2 = depz2



#
# Linear Dimension Data.
#
class DL_DimLinearData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, ddpx1, ddpy1, ddpz1,
				 ddpx2, ddpy2, ddpz2,
				 dAngle, dOblique):
		#X Coordinate of Extension po1.
		self.dpx1 = ddpx1
		#Y Coordinate of Extension po1.
		self.dpy1 = ddpy1
		#Z Coordinate of Extension po1.
		self.dpz1 = ddpz1
		#X Coordinate of Extension po2.
		self.dpx2 = ddpx2
		#Y Coordinate of Extension po2.
		self.dpy2 = ddpy2
		#Z Coordinate of Extension po2.
		self.dpz2 = ddpz2
		#Rotation angle (angle of dimension line) in degrees.
		self.angle = dAngle
		#Oblique angle in degrees.
		self.oblique = dOblique

#
# Radial Dimension Data.
#
class DL_DimRadialData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, ddpx, ddpy, ddpz, dleader):
		#X Coordinate of definition point.
		self.dpx = ddpx
		#Y Coordinate of definition point.
		self.dpy = ddpy
		#Z Coordinate of definition point.
		self.dpz = ddpz
		#Leader length
		self.leader = dleader

#
# Diametric Dimension Data.
#
class DL_DimDiametricData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, ddpx, ddpy, ddpz, dleader):
		#X Coordinate of definition point.
		self.dpx = ddpx
		#Y Coordinate of definition point.
		self.dpy = ddpy
		#Z Coordinate of definition point.
		self.dpz = ddpz
		#Leader length
		self.leader = dleader

#
# Angular Dimension Data.
#
class DL_DimAngularData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, ddpx1, ddpy1, ddpz1,
					ddpx2, ddpy2, ddpz2,
					ddpx3, ddpy3, ddpz3,
					ddpx4, ddpy4, ddpz4):
		#X Coordinate of definition po1.
		self.dpx1 = ddpx1
		#Y Coordinate of definition po1.
		self.dpy1 = ddpy1
		#Z Coordinate of definition po1.
		self.dpz1 = ddpz1
		#X Coordinate of definition po2.
		self.dpx2 = ddpx2
		#Y Coordinate of definition po2.
		self.dpy2 = ddpy2
		#Z Coordinate of definition po2.
		self.dpz2 = ddpz2
		#X Coordinate of definition po3.
		self.dpx3 = ddpx3
		#Y Coordinate of definition po3.
		self.dpy3 = ddpy3
		#Z Coordinate of definition po3.
		self.dpz3 = ddpz3
		#X Coordinate of definition po4.
		self.dpx4 = ddpx4
		#Y Coordinate of definition po4.
		self.dpy4 = ddpy4
		#Z Coordinate of definition po4.
		self.dpz4 = ddpz4

#
# Angular Dimension Data (3 points version).
#
class DL_DimAngular3PData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, ddpx1, ddpy1, ddpz1,
				ddpx2, ddpy2, ddpz2,
				ddpx3, ddpy3, ddpz3):
		#X Coordinate of definition po1.
		self.dpx1 = ddpx1
		#Y Coordinate of definition po1.
		self.dpy1 = ddpy1
		#Z Coordinate of definition po1.
		self.dpz1 = ddpz1
		#X Coordinate of definition po2.
		self.dpx2 = ddpx2
		#Y Coordinate of definition po2.
		self.dpy2 = ddpy2
		#Z Coordinate of definition po2.
		self.dpz2 = ddpz2
		#X Coordinate of definition po3.
		self.dpx3 = ddpx3
		#Y Coordinate of definition po3.
		self.dpy3 = ddpy3
		#Z Coordinate of definition po3.
		self.dpz3 = ddpz3



#
# Leader (arrow).
#
class DL_LeaderData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, lArrowHeadFlag,
				lLeaderPathType,
				lLeaderCreationFlag,
				lHooklineDirectionFlag,
				lHooklineFlag,
				lTextAnnotationHeight,
				lTextAnnotationWidth,
				lNumber):
		#Arrow head flag (71).
		self.arrowHeadFlag = lArrowHeadFlag
		#Leader path type (72).
		self.leaderPathType = lLeaderPathType
		#Leader creation flag (73).
		self.leaderCreationFlag = lLeaderCreationFlag
		#Hookline direction flag (74).
		self.hooklineDirectionFlag = lHooklineDirectionFlag
		#Hookline flag (75):
		self.hooklineFlag = lHooklineFlag
		#Text annotation height (40).
		self.textAnnotationHeight = lTextAnnotationHeight
		#Text annotation width (41):
		self.textAnnotationWidth = lTextAnnotationWidth
		#Number of vertices in leader (76).
		self.number = lNumber

#
# Leader Vertex Data.
#
class DL_LeaderVertexData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, px=0.0, py=0.0, pz=0.0):
		#X Coordinate of the vertex.
		self.x = px
		#Y Coordinate of the vertex.
		self.y = py
		#Z Coordinate of the vertex.
		self.z = pz

#
# Hatch data.
class DL_HatchData :
	#
	# Default conclassor.
	#
	# Conclassor.
	# Parameters: see member variables.

	def __init__(self, hNumLoops,
				hSolid,
				hScale,
				hAngle,
				hPattern):
		#Number of boundary paths (loops).
		self.numLoops = hNumLoops
		#Solid fill flag (true=solid, 'false'=pattern).
		self.solid = hSolid
		#Pattern scale or spacing
		self.scale = hScale
		#Pattern angle
		self.angle = hAngle
		#Pattern name.
		self.pattern = hPattern

#
# Hatch boundary path (loop) data.
class DL_HatchLoopData :
	#
	# Default conclassor.
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, hNumEdges):
		#Number of edges in this loop.
		self.numEdges = hNumEdges

#
# Hatch edge data.

class DL_HatchEdgeData :
	#
	# Default conclassor.

	def __init__(self):
		# Edge type. 1=line, 2=arc.
		self.type = 0
		#Start po(X).
		self.x1 = 0.0
		#Start po(Y).
		self.y1 = 0.0
		#End po(X).
		self.x2 = 0.0
		#End po(Y).
		self.y2 = 0.0
		#Center poof arc (X).
		self.cx = 0.0
		#Center poof arc (Y).
		self.cy = 0.0
		#Arc radius.
		self.radius = 0.0
		#Start angle.
		self.angle1 = 0.0
		#End angle.
		self.angle2 = 0.0
		#Counterclockwise flag.
		self.ccw = 0.0
		# Set to true if this edge is fully defined.
		self.defined = 'false'
	#
	# Conclassor for a line edge.
	# Parameters: see member variables.

	def SetLineEdge(self, lx1, ly1, lx2, ly2):
		#Start po(X).
		self.x1 = lx1
		#Start po(Y).
		self.y1 = ly1
		#End po(X).
		self.x2 = lx2
		#End po(Y).
		self.y2 = ly2
		#
		# Edge type. 1=line, 2=arc.
		self.type = 1
		#
		# Set to true if this edge is fully defined.
		self.defined = 'true'

	#
	# Conclassor for an arc edge.
	# Parameters: see member variables.

	def SetArcEdge(self, acx, acy,
					 aRadius,
					 aAngle1, aAngle2,
					 aCcw):
		#Center poof arc (X).
		self.cx = acx
		#Center poof arc (Y).
		self.cy = acy
		#Arc radius.
		self.radius = aRadius
		#Start angle.
		self.angle1 = aAngle1
		#End angle.
		self.angle2 = aAngle2
		#Counterclockwise flag.
		self.ccw = aCcw
		#
		# Edge type. 1=line, 2=arc.
		self.type = 2
		#
		# Set to true if this edge is fully defined.
		self.defined = 'true'

#
# Image Data.
#
class DL_ImageData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, iref,
				iipx, iipy, iipz,
				iux, iuy, iuz,
				ivx, ivy, ivz,
				iwidth, iheight,
				ibrightness, icontrast, ifade):
		#Reference to the image file 
		#(unique, used to refer to the image def object).
		self.ref = iref
		#X Coordinate of insertion point.
		self.ipx = iipx
		#Y Coordinate of insertion point.
		self.ipy = iipy
		#Z Coordinate of insertion point.
		self.ipz = iipz
		#X Coordinate of u vector along bottom of image.
		self.ux = iux
		#Y Coordinate of u vector along bottom of image.
		self.uy = iuy
		#Z Coordinate of u vector along bottom of image.
		self.uz = iuz
		#X Coordinate of v vector along left side of image.
		self.vx = ivx
		#Y Coordinate of v vector along left side of image.
		self.vy = ivy
		#Z Coordinate of v vector along left side of image.
		self.vz = ivz
		#Width of image in pixel.
		self.width = iwidth
		#Height of image in pixel.
		self.height = iheight
		#Brightness (0..100, default = 50).
		self.brightness = ibrightness
		#Contrast (0..100, default = 50).
		self.contrast = icontrast
		#Fade (0..100, default = 0).
		self.fade = ifade

#
# Image Definition Data.
#
class DL_ImageDefData :
	#
	# Conclassor.
	# Parameters: see member variables.
	def __init__(self, iref,
				 ifile):
		#Reference to the image file 
		#(unique, used to refer to the image def object).
		self.ref = iref
		#Image file
		self.file = ifile
