#include "stdafx.h"

#include "JVMStarter.hpp"
#include "message.h"

#include "EventLog.hpp"
#include "JavaVMCallback.hpp"

#include <assert.h>

namespace
{
	class JVMEventListenerImpl : public JVMEventListener
	{
	public:
		JVMEventListenerImpl( const std::string& v_serviceName, FILE* v_pJVMLog, EventLog& v_eventLog ) throw()
			: serviceName_( v_serviceName )
			, eventLog_( v_eventLog )
			, jvmLog_( v_pJVMLog )
		{
		}

		virtual ~JVMEventListenerImpl() throw()
		{
		}

		virtual void notifyJVMStarted() throw()
		{
			const char* mes[] = { serviceName_.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_STARTED,
				1,
				mes,
				EVENTLOG_INFORMATION_TYPE
				);
		}

		virtual void notifyJVMExited( int v_exitCode ) throw()
		{
			CHAR buf[ 64 ];
			wsprintf( buf, "%d", v_exitCode );
			const char* mes[] = { buf, serviceName_.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_EXITED,
				2,
				mes,
				EVENTLOG_INFORMATION_TYPE
				);
		}

		virtual void notifyJVMAborted() throw()
		{
			const char* mes[] = { serviceName_.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_ABORTED,
				1,
				mes,
				EVENTLOG_ERROR_TYPE
				);
		}

		virtual void notifyException( const std::string& v_target ) throw()
		{
			const char* mes[] = { v_target.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_EXCEPTION,
				1,
				mes,
				EVENTLOG_ERROR_TYPE
				);
		}

		virtual int notifyJVMLog( FILE* v_fp, const char* v_format, va_list v_args ) throw()
		{
			if( jvmLog_ != NULL ) {
				return vfprintf( jvmLog_, v_format, v_args );
			}
			return 0;
		}

		virtual void notifyJVMThreadNormalyTerminated( const std::string& v_target ) throw()
		{
			const char* mes[] = { v_target.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_THREAD_NORMALY_TERMINATED,
				1,
				mes,
				EVENTLOG_INFORMATION_TYPE
				);
		}

		virtual void notifyJVMThreadAbnomalTerminated( const std::string& v_target, const std::string& v_reason ) throw()
		{
			const char* mes[] = { v_target.c_str(), v_reason.c_str() };
			eventLog_.reportEvent(
				MSG_JAVAVM_THREAD_ABNORMAL_TERMINATED,
				2,
				mes,
				EVENTLOG_ERROR_TYPE
				);
		}

		virtual void notifyLibraryLoadFailure( const std::string& v_dllPath ) throw()
		{
			const char* mes[] = { v_dllPath.c_str() };
			eventLog_.reportEvent(
				MSG_PRELOADLIB_FAILURE,
				1,
				mes,
				EVENTLOG_ERROR_TYPE
				);
		}

	private:
		std::string serviceName_;
		FILE* jvmLog_;
		EventLog& eventLog_;
	};

	/*!
	 * W[̃tpXgqŎw肵Œu܂B
	 * uɎsꍇ͋󕶎Ԃ܂B
	 * \param v_ext ugq
	 * \return uꂽA܂͋󕶎
	 */
	std::string GetConfPath( const std::string& v_ext ) throw()
	{
		CHAR preloadConfPath[ MAX_PATH + 9 ];
		preloadConfPath[ GetModuleFileName( NULL, preloadConfPath, MAX_PATH ) ] = 0;
		LPSTR p = preloadConfPath;
		while(*p)p++;
		while( p > preloadConfPath && *p != '\\' ) {
			if( *p == '.' ) {
				strcpy( p, v_ext.c_str() );
				break;
			}
			p = CharPrev( preloadConfPath, p );
		}
		if( p == preloadConfPath || *p == '\\' ) {
			return std::string();
		}
		return std::string( preloadConfPath );
	}

	/*!
	 * CxgO
	 */
	EventLog* pEventLog_ = NULL;

	/*!
	 * JNIpݐ
	 */
	FILE* jvmLogFP_ = NULL;

	/*!
	 * JVM̃CxgXi
	 */
	JVMEventListenerImpl* pEventListener_ = NULL;

	/*!
	 * IɃN[ibv̂߂ɌĂяo郋[`
	 */
	void cleanup()
	{
		delete pEventListener_;
		delete pEventLog_;
		if( jvmLogFP_ != NULL ) {
			fclose( jvmLogFP_ );
		}
	}
}

void jvm_main( const std::string& v_serviceName, const std::string& v_configPath ) throw()
{
	if( v_serviceName.empty() || v_configPath.empty() ) {
		exit( 3 );
	}

	// N[ibv̓o^

	atexit( cleanup );

	// \[X̃ZbgAbv

	pEventLog_ = new EventLog( v_serviceName );
	pEventLog_->registerEventSource();
	pEventLog_->open();

	std::string logExtention;
	logExtention += ".log";
	logExtention += v_serviceName;
	const std::string jvmLogPath( GetConfPath( logExtention ) );
	if( ! jvmLogPath.empty() ) {
		jvmLogFP_ = fopen( jvmLogPath.c_str(), "w" );
	}

	pEventListener_ = new JVMEventListenerImpl( v_configPath, jvmLogFP_, *pEventLog_ );
	const std::string preloadConfPath( GetConfPath( ".preload" ) );

	// JVM̍쐬Ǝs

	JVMStarter jvmStarter( *pEventListener_ );
	if( jvmStarter.preloadLibrary( preloadConfPath ) ) {
		// ɏIꍇAJVMSystem#exitĂ΂ꂽꍇ́A
		// exit()̌Ăяoɂ萧͖߂܂B
		// JVMĂяoɎsꍇł͐䂪߂܂B
		jvmStarter.start( v_configPath );
		jvmStarter.waitForFinishedAll();
	}

	exit( 3 );
}
