#ifndef INCLUDE_H_WIN32EXCEPTION
#define INCLUDE_H_WIN32EXCEPTION

#include <string>
#include <exception>

#include <windows.h>

class Win32Exception : public std::exception
{
public:
	Win32Exception( const char* v_message, DWORD v_errorCode );
	DWORD getErrorCode() const;

	static void checkAndThrow( BOOL v_succeeded = FALSE ) throw ( Win32Exception );
	static void throwWin32Exception( DWORD v_errorCode ) throw ( Win32Exception );

private:
	DWORD errorCode_;
};

#endif
