#ifndef INCLUDE_H_STARTUPINFO
#define INCLUDE_H_STARTUPINFO

#include <string>
#include <vector>

class StartupInfo
{
public:
	typedef std::vector<std::string> StringVector;

	typedef StringVector::iterator iterator;
	typedef StringVector::const_iterator const_iterator;
	typedef StringVector::value_type value_type;
	typedef StringVector::size_type size_type;
	typedef StringVector::reference reference;
	typedef StringVector::const_reference const_reference;

	StartupInfo( const std::string v_mainClassName, const std::string v_mainMethodName, bool v_fork ) throw ( std::invalid_argument );
	StartupInfo( const StartupInfo& v_other ) throw();
	StartupInfo& operator=( const StartupInfo& v_other ) throw();
	~StartupInfo() throw();

	const std::string& getMainClassName() const throw();
	const std::string& getMainMethodName() const throw();

	bool isFork() const throw();

	StartupInfo::iterator begin() throw();
	StartupInfo::const_iterator begin() const throw();
	StartupInfo::iterator end() throw();
	StartupInfo::const_iterator end() const throw();
	StartupInfo::size_type size() const throw();

	bool push_back( const std::string& v_arg ) throw();

private:
	std::string mainClassName_;
	std::string mainMethodName_;
	StringVector args_;
	bool fork_;
};


#endif
