#include "stdafx.h"

#include "StartupInfo.hpp"

StartupInfo::StartupInfo( const std::string v_mainClassName, const std::string v_mainMethodName, bool v_fork ) throw ( std::invalid_argument )
	: mainClassName_( v_mainClassName )
	, mainMethodName_( v_mainMethodName )
	, fork_( v_fork )
{
	if( v_mainClassName.empty() ) {
		throw std::invalid_argument( "CNXw肳Ă܂B" );
	}
	if( v_mainMethodName.empty() ) {
		throw std::invalid_argument( "C\bhw肳Ă܂B" );
	}
}

StartupInfo::StartupInfo( const StartupInfo& v_other ) throw()
	: mainClassName_( v_other.mainClassName_ )
	, mainMethodName_( v_other.mainMethodName_ )
	, args_( v_other.args_ )
	, fork_( v_other.fork_ )
{
}

StartupInfo& StartupInfo::operator=( const StartupInfo& v_other ) throw()
{
	if( this != &v_other ) {
		mainClassName_ = v_other.mainClassName_;
		mainMethodName_ = v_other.mainMethodName_;
		args_ = v_other.args_;
		fork_ = v_other.fork_;
	}
	return *this;
}

StartupInfo::~StartupInfo() throw()
{
}

bool StartupInfo::isFork() const throw()
{
	return fork_;
}

const std::string& StartupInfo::getMainClassName() const throw() 
{
	return mainClassName_;
}

const std::string& StartupInfo::getMainMethodName() const throw()
{
	return mainMethodName_;
}

StartupInfo::iterator StartupInfo::begin() throw()
{
	return args_.begin();
}

StartupInfo::const_iterator StartupInfo::begin() const throw()
{
	return args_.begin();
}

StartupInfo::iterator StartupInfo::end() throw()
{
	return args_.end();
}

StartupInfo::const_iterator StartupInfo::end() const throw()
{
	return args_.end();
}

StartupInfo::size_type StartupInfo::size() const throw()
{
	return args_.size();
}

bool StartupInfo::push_back( const std::string& v_arg ) throw()
{
	if( ! v_arg.empty() ) {
		args_.push_back( v_arg );
		return true;
	}
	return false;
}
