#include "stdafx.h"

#include "ServiceRegisterCommand.hpp"

#include <iterator>
#include <algorithm>

#include <assert.h>

ServiceRegisterBase::ServiceRegisterBase( const CommandArgument& v_argument ) throw ( std::exception )
	: Command( v_argument )
{
}

ServiceRegisterBase::~ServiceRegisterBase() throw()
{
}

////

ServiceRegisterCommand::ServiceRegisterCommand( const CommandArgument& v_argument ) throw ( std::exception )
	: ServiceRegisterBase( v_argument )
{
}

ServiceRegisterCommand::~ServiceRegisterCommand() throw()
{
}

void ServiceRegisterCommand::execute() throw ( std::exception )
{
	assert( ! argument_.getServiceName().empty() );
	assert( ! argument_.getConfigPath().empty() );

	std::string displayName;
	std::string command;

	displayName += "JavaVMService(";
	displayName += argument_.getServiceName();
	displayName += ")";

	command += "--runService ";
	command += argument_.getServiceName();
	command += " -c \"";
	command += argument_.getConfigPath();
	command += "\"";

	if( ! argument_.getLogPath().empty() ) {
		command += " -l \"";
		command += argument_.getLogPath();
		command += "\"";
	}

	ServiceRegistParam param( argument_.getServiceName(), displayName, command );
	std::copy( argument_.begin(), argument_.end(), std::back_insert_iterator<ServiceRegistParam::StringVector>( param.dependencies() ) );

	serviceControlManager_.createOrReplaceService( param );
}

////

ServiceUnregisterCommand::ServiceUnregisterCommand( const CommandArgument& v_argument ) throw ( std::exception )
	: ServiceRegisterBase( v_argument )
{
}

ServiceUnregisterCommand::~ServiceUnregisterCommand() throw()
{
}

void ServiceUnregisterCommand::execute() throw ( std::exception )
{
	assert( ! argument_.getServiceName().empty() );

	ServiceIdentifier serviceIdentifier( argument_.getServiceName() );
	serviceControlManager_.deleteService( serviceIdentifier );
}
