#ifndef INCLUDE_H_JAVAVMCALLBACK
#define INCLUDE_H_JAVAVMCALLBACK

class JVMEventListener
{
public:
	virtual ~JVMEventListener() throw() {}

	virtual void notifyLibraryLoadFailure( const std::string& v_dllPath ) throw() = 0;

	virtual void notifyJVMStarted() throw() = 0;

	/*!
	 * JavaVMIƂʒm܂B
	 * ̃R[obN߂exit(0)̌Ăяos邽߁A
	 * KvȂ΁ÃR[obNexit()ĂяoĂ܂܂B
	 */
	virtual void notifyJVMExited( int v_exitCode ) throw() = 0;

	/*!
	 * JavaVMُIƂʒm܂B
	 * ̃R[obN߂exit(3)̌Ăяos邽߁A
	 * KvȂ΁ÃR[obNexit()ĂяoĂ܂܂B
	 */
	virtual void notifyJVMAborted() throw() = 0;

	virtual void notifyException( const std::string& v_target ) throw() = 0;

	virtual int notifyJVMLog( FILE* v_fp, const char* v_format, va_list v_args ) throw() = 0;

	virtual void notifyJVMThreadNormalyTerminated( const std::string& v_target ) throw() = 0;
	
	virtual void notifyJVMThreadAbnomalTerminated( const std::string& v_target, const std::string& v_reason ) throw() = 0;
};

#endif
