#include "stdafx.h"

#include "JVMThreadAttacher.hpp"

#include <assert.h>

/*!
 * XbhɃA^b`܂B
 * łɃA^b`Ăꍇ͂Ȃɂ܂B
 * A^b`łȂꍇ͗O܂B
 * \param v_jvm JavaVMւ̃|C^
 */
JVMThreadAttacher::JVMThreadAttacher( JavaVM* v_jvm ) throw ( std::runtime_error )
	: jvm_( v_jvm )
	, env_( NULL )
	, attached_( false )
{
	//required:
	assert( v_jvm != NULL );

	//do:
	if( jvm_->GetEnv( (void**) &env_, JNI_VERSION_1_2 ) != JNI_OK || env_ == NULL ) {
		// A^b`ĂȂꍇ̓A^b`B
		JavaVMAttachArgs attach_args;
		attach_args.version = JNI_VERSION_1_2;
		attach_args.name = NULL;
		attach_args.group = NULL;
		if( jvm_->AttachCurrentThread( (void**) &env_, &attach_args ) != 0 || env_ == NULL ) {
			throw std::runtime_error( "XbhɃA^b`ł܂B" );
		}
		attached_ = true;
	}
}

/*!
 * A^b`ꂽꍇ́ÃA^b`܂B
 * ̃IuWFNgɂA^b`ĂȂꍇ͉܂B
 */
JVMThreadAttacher::~JVMThreadAttacher() throw()
{
	if( attached_ ) {
		jvm_->DetachCurrentThread();
	}
}

JNIEnv* JVMThreadAttacher::getJNIEnv()
{
	return env_;
}
