#include "stdafx.h"

#include "JVMException.hpp"

#include <assert.h>

#include <string>
#include <vector>

JVMException::JVMException( const char* v_message )
	: std::runtime_error( v_message )
{
}

/*!
 * JavaVMŗOĂ邩`FbNAĂJVMExceptionO𔭐܂B
 * \param env JNIANZX̂߂̃XbhƂ̊
 */
void JVMException::checkAndThrow( JNIEnv* env ) throw( JVMException )
{
	//required:
	assert( env != NULL );

	//do:
	jthrowable err = env->ExceptionOccurred();
	env->ExceptionClear();
	if( err != NULL ) {
		jclass throwableClass = env->GetObjectClass( err );
		jmethodID toStringMethodID = env->GetMethodID( throwableClass, "toString", "()Ljava/lang/String;" );
		assert( toStringMethodID != NULL );
		jstring errDescription = reinterpret_cast<jstring>(env->CallObjectMethod( err, toStringMethodID ));
		
		std::string message( "unknown exception" );

		const jsize len = env->GetStringLength( errDescription );
		const jchar* szErrDescription = env->GetStringChars( errDescription, NULL );
		if( szErrDescription != NULL ) {
			int buflen = WideCharToMultiByte( GetACP(), 0, reinterpret_cast<LPCWSTR>( szErrDescription ), len, NULL, 0, NULL, NULL );
			if( buflen != 0 ) {
				std::vector<char> buf( buflen + 1 );
				buflen = WideCharToMultiByte( GetACP(), 0, reinterpret_cast<LPCWSTR>( szErrDescription ), len, &buf[ 0 ], buflen, NULL, NULL );
				if( buflen != 0 ) {
					buf[ buflen ] = 0;
					message = &buf[ 0 ];
				}
			}
			env->ReleaseStringChars( errDescription, szErrDescription );
		}
		
		throw JVMException( message.c_str() );
	}
}

