#ifndef INCLUDE_H_EVENTOBJECT
#define INCLUDE_H_EVENTOBJECT

#include <exception>

class EventRef
{
public:
	EventRef( bool v_auto = false, bool v_initialState = false ) throw ( std::exception );
	EventRef( const EventRef& v_event ) throw();
	EventRef& operator=( const EventRef& v_event ) throw();
	~EventRef() throw();

	bool waitForSignal( DWORD v_wait = INFINITE ) throw();
	void signal( bool v_state ) throw();
	void pulse() throw();

private:
	struct EventData_
	{
		HANDLE hEvent_;
		int ref_;
	};

	mutable EventData_* pEventData_;
};

template< class T >
class EventSentinel
{
private:
	EventSentinel( const EventSentinel& ); //<! Ȃ
	operator=( const EventSentinel& ); //<! Ȃ

public:
	EventSentinel( T& v_eventRef ) throw()
		: eventRef_( v_eventRef )
		, signaled_( false )
	{
	}

	~EventSentinel() throw()
	{
		signal();
	}

	void signal() throw()
	{
		if( ! signaled_ ) {
			eventRef_.signal();
			signaled_ = true;
		}
	}

private:
	T& eventRef_;
	bool signaled_;
};

#endif
