#ifndef INCLUDE_H_SERVICEAGUMENT
#define INCLUDE_H_SERVICEAGUMENT

#include <vector>
#include <string>

class CommandArgument
{
private:
	typedef std::vector<std::string> StringVector;
	
	friend class CommandArgumentFactory;

	CommandArgument() throw();
	CommandArgument& operator=( const CommandArgument& ) throw(); //<! Ȃ

public:

	typedef StringVector::const_iterator const_iterator;
	typedef StringVector::size_type size_type;
	typedef StringVector::value_type value_type;
	typedef StringVector::const_reference const_reference;

	enum cmdtype
	{
		cmdtype_none,
		cmdtype_runservice,
		cmdtype_regist,
		cmdtype_unregist
	};

	CommandArgument( const CommandArgument& ) throw();
	~CommandArgument() throw();

	size_type size() const throw();
	const_iterator begin() const throw();
	const_iterator end() const throw();

	const cmdtype getCommandType() const throw();
	const std::string& getServiceName() const throw();
	const std::string& getConfigPath() const throw();
	const std::string& getLogPath() const throw();

private:
	cmdtype cmdtype_;
	std::string serviceName_;
	std::string configPath_;
	std::string logPath_;
	StringVector dependencies_;
};

class CommandArgumentFactory
{
private:
	typedef std::vector<std::string> StringVector;

	CommandArgumentFactory() throw();
	~CommandArgumentFactory() throw();

public:
	static CommandArgument create( int argc, char* argv[] ) throw ( std::exception );
	static void showHelp() throw();

private:
	void validate() const throw ( std::exception );

	int getOptionLength( const std::string& v_arg ) throw( std::exception );
	void parse( const StringVector& v_args ) throw ( std::exception );

	bool acceptDependencies_;
	CommandArgument target_;
};


#endif
