#ifndef INCLUDE_H_COMMAND
#define INCLUDE_H_COMMAND

#include <exception>
#include <memory>

#include "CommandArgument.hpp"

class Command;
typedef std::auto_ptr<Command> CommandPtr;

class Command
{
protected:
	Command( const CommandArgument& v_argument ) throw ( std::exception );

public:
	virtual ~Command() throw();
	virtual void execute() throw ( std::exception ) = 0;

	static CommandPtr create( const CommandArgument& v_argument ) throw ( std::exception );

protected:
	const CommandArgument argument_;
};

#endif
