#include "stdafx.h"

#include "Command.hpp"
#include "ServiceRegisterCommand.hpp"
#include "ServiceLaunchCommand.hpp"

#include <assert.h>

namespace
{
	class ShowHelpCommand : public Command
	{
	public:
		ShowHelpCommand( const CommandArgument& v_argument ) throw ( std::exception )
			: Command( v_argument )
		{
		}

		virtual ~ShowHelpCommand() throw()
		{
		}

		virtual void execute() throw ( std::exception )
		{
			CommandArgumentFactory::showHelp();
		}
	};

}

Command::Command( const CommandArgument& v_argument ) throw ( std::exception )
	: argument_( v_argument )
{
}

Command::~Command() throw()
{
}

CommandPtr Command::create( const CommandArgument& v_argument ) throw ( std::exception )
{
	// Windows2000/XP/2003ȍ~ł邩`FbN

	OSVERSIONINFOEX versionInfo = { 0 };
	versionInfo.dwOSVersionInfoSize = sizeof( OSVERSIONINFOEX );
	versionInfo.dwMajorVersion = 5;

	DWORDLONG dwlConditionMask = 0;
	VER_SET_CONDITION( dwlConditionMask, VER_MAJORVERSION, VER_GREATER_EQUAL );
	
	if( VerifyVersionInfo( &versionInfo, VER_MAJORVERSION, dwlConditionMask ) == 0 ) {
		Win32Exception::throwWin32Exception( GetLastError() );
	}

	// R}h蓖Ă

	CommandPtr cmd;

	switch( v_argument.getCommandType() )
	{
	case CommandArgument::cmdtype_none:
		cmd = CommandPtr( new ShowHelpCommand( v_argument ) );
		break;

	case CommandArgument::cmdtype_regist:
		cmd = CommandPtr( new ServiceRegisterCommand( v_argument ) );
		break;

	case CommandArgument::cmdtype_unregist:
		cmd = CommandPtr( new ServiceUnregisterCommand( v_argument ) );
		break;

	case CommandArgument::cmdtype_runservice:
		cmd = CommandPtr( new ServiceLaunchCommand( v_argument ) );
		break;

	default:
		assert( false && "sȃR}h^Cv" );
		throw std::invalid_argument( "sȃR}h^Cvw肳Ă܂B" );
	}

	assert( cmd.get() != NULL );
	return cmd;
}

