package junkutil.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JFrame;

/**
 * JFramepNX
 * @author Hiroyuki Shiota
 */
public class LzFrame extends JFrame {

	public LzFrame() {
		this(null, 640, 480);
	}
	
	public LzFrame(int width, int height) {
		this(null, width, height);
	}
	
	public LzFrame(String title) {
		this(title, 640, 480);
	}

	public LzFrame(String title, int width, int height) {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		if (title != null) setTitle(title);
		setSize(width, height);
	}

	private KeyAdapter escKeyAdapter = new KeyAdapter() {
		public void keyPressed(KeyEvent e) {
			super.keyPressed(e);
			if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
				dispose();
			}
		}
	};
	
	public void setEscapeToDispose(boolean b) {
		if (b) {
			KeyListener [] list = getKeyListeners();
			for (int i = 0; i < list.length; i++) {
				if (list[i] == escKeyAdapter) return;
			}
			addKeyListener(escKeyAdapter);
		} else {
			removeKeyListener(escKeyAdapter);
		}
	}
}
