package junkutil.sample;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import junkutil.common.FileUtil;
import junkutil.common.OptGets;
import junkutil.set.LzList;
import junkutil.set.LzListClosure;
import junkutil.set.LzMap;
import junkutil.set.LzMapClosure;

/**
 * ɗ^ꂽt@C̒ŁApŎn܂so͂vOB
 *  -h Ńwb_[o͂BN[WpB
 * @author Hiroyuki Shioa
 */
public class BatchTest2 {

	/**
	 * Mapo͂N[W
	 */
	private static class MapDump implements LzMapClosure {
		public boolean process(Object key, Object value) {
			System.out.println(key + "=" + value);
			return false;
		};
	}

	/**
	 * Xgo͂N[W
	 */
	private static class ListDump implements LzListClosure {
		public boolean process(int i, int len, Object obj) {
			System.out.println(obj);
			return false;
		}
	}

	/**
	 * t@Co͂N[W
	 */
	private static class FileDataDump implements LzListClosure {
		public boolean process(int i, int len, Object obj) {
			String filename = (String)obj;
			if (!FileUtil.exists(filename)) {
				System.out.println("File not found: " + filename);
				return false;
			} else {
				System.out.println("File: " + filename);
				List lines = null;
				try {
					lines = FileUtil.readLines(filename, "Shift_JIS");
					new LzList(lines).grep("^[a-zA-Z]").forEach(new ListDump());
				} catch (IOException e) {
					e.printStackTrace();
				}
				return true;
			}
		}
	}

	/**
	 * C
	 * @param args
	 */
	public static void main(String [] args) {
		args = new String[] { "-h", "testdata/readFile.txt", "testdata/writeFile.txt", "Nothing.txt" };
		OptGets optGets = new OptGets("abch");
		Map opts = optGets.parse(args);
		if (opts.get("h") == Boolean.TRUE) {
			System.out.println("====BatchTest Heaader====");
		}
		List argList = optGets.getArgList();
		new LzMap(opts).forEach(new MapDump()); //Map_v
		new LzList(argList).forEach(new FileDataDump()); //t@C_v
	}
}
