/*
 * Decompiled with CFR 0.152.
 */
package junkutil.crypt;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DES {
    public static final String DES_ALGORITHM = "DES";
    public static final String DESEDE_ALGORITHM = "DESede";
    public static final String AES_ALGORITHM = "AES";
    public static final String BLOWFISH_ALGORITHM = "Blowfish";
    public static final String RC2_ALGORITHM = "RC2";
    public static final String RC4_ALGORITHM = "RC4";
    private String algorithm = "DES";

    public DES() {
    }

    public DES(String algorithm) {
        this.algorithm = algorithm;
    }

    public static String encodeBASE64(byte[] bytes) {
        return new BASE64Encoder().encodeBuffer(bytes);
    }

    public static byte[] decodeBASE64(String value) throws IOException {
        return new BASE64Decoder().decodeBuffer(value);
    }

    public String createKey() throws NoSuchAlgorithmException, IOException {
        return this.createKey(null);
    }

    public String createKey(String seed) throws NoSuchAlgorithmException, IOException {
        SecureRandom secureRandom = null;
        secureRandom = seed != null ? new SecureRandom(DES.decodeBASE64(seed)) : new SecureRandom();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(this.algorithm);
        keyGenerator.init(secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        return DES.encodeBASE64(secretKey.getEncoded());
    }

    private Key asKey(byte[] key) {
        SecretKeySpec secretKey = new SecretKeySpec(key, this.algorithm);
        return secretKey;
    }

    public byte[] encrypt(byte[] data, String key) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Key secretKey = this.asKey(DES.decodeBASE64(key));
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, secretKey);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data, String key) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Key secretKey = this.asKey(DES.decodeBASE64(key));
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, secretKey);
        return cipher.doFinal(data);
    }
}

