package org.junitdoc.preferences;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PreferencesMessages {
	private static final String BUNDLE_NAME = "org.junitdoc.preferences.messages"; //$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle
			.getBundle(BUNDLE_NAME);

	private PreferencesMessages() {
	}

	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
}
