package org.junitdoc.core.rewriter;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.junitdoc.core.jdt.Method;

public class IncludeMethodHandler extends RewriteHandlerAdapter {

	private String decisionTableName;

	private MarkerAnnotation newAnnotation;

	private Method method;

	public IncludeMethodHandler(String decisionTableName, IMethod testMethod) {
		this.decisionTableName = decisionTableName;
		this.method = new Method(testMethod);
	}

	@Override
	public boolean confirmRewrite() {
		if (method.getSource() == null) {
			return false;
		}
		if (method.hasMarkerAnnotation(decisionTableName)) {
			return false;
		}

		return true;
	}

	public void rewrite(ASTNode node, ASTRewrite rewrite) {

		AST ast = node.getAST();

		ListRewrite listRewrite = rewrite.getListRewrite(method
				.getSource(), MethodDeclaration.MODIFIERS2_PROPERTY);

		newAnnotation = ast.newMarkerAnnotation();
		newAnnotation.setTypeName(ast.newName(decisionTableName));

		listRewrite.insertFirst(newAnnotation, null);

	}

	@Override
	public void afterRewrite(ICompilationUnit source) {
		method.selectAndReveal();
	}
}
