/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* mymalloc.c --- malloc function with error trap */

/* $Id: mymalloc.c,v 1.3 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>


/* generic allocations with error trap */
void *
mymalloc(int size)
{
  void *p;
  if ( (p = malloc(size)) == NULL) {
    j_error("cannot malloc %d byte\n",size);
  }
  return p;
}

void *
myrealloc(void *ptr, int size)
{
  void *p;
  if ( (p = realloc(ptr,size)) == NULL) {
    j_error("cannot realloc %d byte\n",size);
  }
  return p;
}
void *
mycalloc(int nelem, int elsize)
{
  void *p;
  if ( (p = calloc(nelem,elsize)) == NULL) {
    j_error("cannot calloc %d x %d byte\n",nelem, elsize);
  }
  return p;
}

