package net.bakingpowder.tmiz.simpleproxy.base;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

/**
 * @author Tomoo D. Mizukami/JAIST/Softbank Publishing Inc.
 *
 * This class is multi-thread class for buffer-interchange-function.
 */
public class Input2Output implements Runnable {
	private InputStream in = null;
	private OutputStream out = null;
	private ConnectControl cc = null;
	private byte buffer[] = null;
	private static int BUFFER_SIZE = 4096;

	/**
	 * @param in InputStream
	 * @param out OutputStream
	 * @param cm ConnectControl
	 */
	public Input2Output(InputStream in, OutputStream out, ConnectControl cc) {
		this.in = in;
		this.out = out;
		this.cc = cc;
		buffer = new byte[BUFFER_SIZE];

		Thread t = new Thread(this);
		t.start();
	}

	public void run() {
		try {
			int bytesRead = 0;

			while (true) {
				if ((bytesRead = in.read(buffer, 0, BUFFER_SIZE)) == -1)
					break;

				out.write(buffer, 0, bytesRead);
			}
		} catch (IOException e) {
			//ignore;
		}
		cc.ThreadArrivedEnd(this);
	}
}