/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: kernel_cfg.h,v 1.5 2003/12/06 13:09:46 hiro Exp $
 */

/*
 *	kernel_cfg.c ѥ󥯥롼ɥե
 */

#ifndef _KERNEL_CFG_H_
#define _KERNEL_CFG_H_

/*
 *  ͥɸ।󥯥롼ɥե
 */
#include <../kernel/jsp_kernel.h>

/*
 *  ͥγƥ󥯥롼ɥե
 */
#include <../kernel/task.h>
#include <../kernel/semaphore.h>
#include <../kernel/eventflag.h>
#include <../kernel/dataqueue.h>
#include <../kernel/mailbox.h>
#include <../kernel/mempfix.h>
#include <../kernel/cyclic.h>
#include <../kernel/interrupt.h>
#include <../kernel/exception.h>
#include <../kernel/time_event.h>

/*
 *  ͥΥꥢ뤿Υǡ
 *
 *  åΰȸĹסΰVPΥ礭ñ
 *  ̤ǥ饤󤵤ɬפˤϡ__STK_UNIT __MPF_UNIT 
 *  줾쥢饤󤵤ñ̤Υǡ롥
 *
 *  ʲϡ__STK_UNIT  __MPF_UNIT Υ 2ζҾǤ
 *  뤳ȤꤷƤ롥
 */

#ifndef __STK_UNIT
typedef VP	__STK_UNIT;
#endif /* __STK_UNIT */

#ifndef __MPF_UNIT
typedef VP	__MPF_UNIT;
#endif /* __MPF_UNIT */

#define __TROUND_STK_UNIT(sz) \
		(((sz) + sizeof(__STK_UNIT) - 1) & ~(sizeof(__STK_UNIT) - 1))
#define __TCOUNT_STK_UNIT(sz) \
		(((sz) + sizeof(__STK_UNIT) - 1) / sizeof(__STK_UNIT))

#define __TROUND_MPF_UNIT(sz) \
		(((sz) + sizeof(__MPF_UNIT) - 1) & ~(sizeof(__MPF_UNIT) - 1))
#define __TCOUNT_MPF_UNIT(sz) \
		(((sz) + sizeof(__MPF_UNIT) - 1) / sizeof(__MPF_UNIT))

/*
 *  ͡षܥ򸵤᤹Υ󥯥롼ɥե
 */
#include <../kernel/jsp_unrename.h>
#include <sys_unrename.h>
#include <cpu_unrename.h>

#endif /* _KERNEL_CFG_H_ */
