/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_context.h,v 1.9 2003/12/15 07:19:22 takayuki Exp $
 */

/*
 *	ƥ롼
 *
 *  Υե cpu_config.h ʬΥƤΤϡΥե TCB
 *  줿ɤɬפΤФơcpu_config.h ˤ TCB 
 *  ɤɬפޤǤ뤿Ǥ롥
 */

#ifndef _CPU_CONTEXT_H_
#define _CPU_CONTEXT_H_

#include "task.h"

/*
 *  ƥȤν
 *
 *  ٻ߾֤˰ܹԤʥνλˤ˸
 *  Ф롥ŪˤϡƥȤ򥿥ưǤ֤
 *  ꤹcreate_context  activate_context ǹԤФ褤
 */
Inline void
create_context(TCB *tcb)
{
	tcb->tskctxb.ThreadID       = 0;
	tcb->tskctxb.InterruptLevel = 0;
}

/*
 *  εư
 *
 *  ٻ߾֤¹ԤǤ֤˰ܹԤ˸ƤФ롥
 */
extern DWORD WINAPI activate_r(LPVOID);

Inline void
activate_context(TCB *tcb)
{
	tcb->tskctxb.ThreadHandle = CreateThread(NULL,0,activate_r,(LPVOID)tcb,CREATE_SUSPENDED,&tcb->tskctxb.ThreadID);
    FatalAssertion(tcb->tskctxb.ThreadHandle != NULL, "activate_context could not create a thread");
}

/*
 *  ext_tsk å˳ݤߡΰΥ
 */
#define	ACTIVATED_STACK_SIZE	0

#endif /* _CPU_CONTEXT_H_ */
