/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2006 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *ꥢI/OǥХSIO/SCIF˥ɥ饤СCRB_H3ѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include "sh7047scif.h"
#endif /* _MACRO_ONLY */

/*
 *  SIO/SCIFγߥϥɥΥ٥ֹ
 */
/* ϥݡȤsys_config.c */
/* ߥ٥ֹhw_serial.h */
/* ֥åsh7615scif.c */

#define INHNO_SERIAL_IN	   RXI_3
#define INHNO_SERIAL_OUT   TXI_3
#define INHNO_SERIAL_ERROR ERI_3
#if TNUM_PORT >= 2
#define INHNO_SERIAL2_IN   RXI_4
#define INHNO_SERIAL2_OUT  TXI_4
#define INHNO_SERIAL2_ERROR ERI_4
#endif /* TNUM_PORT >= 2 */

/*
 * SCIγߥ٥
 * ߥϥɥ̡ϿǤ뤬ߥ٥
 * Ʊ٥ˤǤʤ
 */
#define LEVEL0		0			/*  ߲Υ٥  */

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize	sh7047scif_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = sh7047scif_openflag (siopid);

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = sh7047scif_opn_por(siopid, exinf);

	/*
	 *  ߥȥ¸
	 *  ꥢI/Oߤγߥ٥ꤹ
	 */
	if (!openflag) {
		define_int_plevel ((VH*)siopcb->siopinib->intctl, siopcb->siopinib->level, siopcb->siopinib->shift);
	}
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	sh7047scif_cls_por(siopcb);

	/*
	 *  ꥢI/Oߥ٥٥ˤ
	 */
	define_int_plevel ((VH*)siopcb->siopinib->intctl, LEVEL0, siopcb->siopinib->shift);

}

/*
 *  SIO/SCIFγߥϥɥ
 */
#define	sio_handler_in	sh7047scif3_isr_in	/*  ߥϥɥ  */
#define	sio_handler_out	sh7047scif3_isr_out	/*  ߥϥɥ  */
#define	sio_handler_error sh7047scif3_isr_error	/*  顼ߥϥɥ  */
#if TNUM_PORT >= 2
#define	sio_handler2_in		sh7047scif4_isr_in	/*  ߥϥɥ  */
#define	sio_handler2_out	sh7047scif4_isr_out	/*  ߥϥɥ  */
#define	sio_handler2_error	sh7047scif4_isr_error	/*  顼ߥϥɥ  */
#endif /* TNUM_PORT >= 2 */

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr	sh7047scif_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr	sh7047scif_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr	sh7047scif_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr	sh7047scif_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_snd	sh7047scif_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_rcv	sh7047scif_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
