/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Cronus Computer Works, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id
 */

/*
 *  ꥢI/OǥХSIO/SCIF˥ɥ饤СCQ_FRKSH2Aѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include "sh726xscif.h"
#endif /* _MACRO_ONLY */

/*
 *  SIO/SCIFγߥϥɥΥ٥ֹ
 */

#ifndef GDB_STUB

#define REGBASE_SERIAL		SCIF2_BASE
#define INHNO_SERIAL_IN		INT_RXI2
#define INHNO_SERIAL_OUT	INT_TXI2
#define INHNO_SERIAL_ERROR	INT_ERI2
#define INHNO_SERIAL_BRK	INT_BRI2
#if TNUM_PORT >= 2
#define REGBASE_SERIAL2		SCIF3_BASE
#define INHNO_SERIAL2_IN	INT_RXI3
#define INHNO_SERIAL2_OUT	INT_TXI3
#define INHNO_SERIAL2_ERROR	INT_ERI3
#define INHNO_SERIAL2_BRK	INT_BRI3
#endif /* TNUM_PORT >= 2 */

#else	/*  GDB_STUB  */

#define REGBASE_SERIAL		SCIF3_BASE
#define INHNO_SERIAL_IN		INT_RXI3
#define INHNO_SERIAL_OUT	INT_TXI3
#define INHNO_SERIAL_ERROR	INT_ERI3
#define INHNO_SERIAL_BRK	INT_BRI3

#endif	/*  GDB_STUB  */

/*
 * SCIγߥ٥
 * ߥϥɥ̡ϿǤ뤬ߥ٥
 * Ʊ٥ˤǤʤ
 */
#define LEVEL0		0			/*  ߲Υ٥  */

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize	sh2scif_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = sh2scif_openflag (siopid);

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = sh2scif_opn_por(siopid, exinf);

	/*
	 *  ߥȥ¸
	 *  ꥢI/Oߤγߥ٥ꤹ
	 */
	if (!openflag) {
		if (siopcb->siopinib->reg_base == SCIF2_BASE)
			define_int_plevel (IPR17, siopcb->siopinib->int_level, 4);
		if ((siopcb->siopinib->reg_base) == SCIF3_BASE)
			define_int_plevel (IPR17, siopcb->siopinib->int_level, 0);
	}
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	sh2scif_cls_por(siopcb);

	/*
	 *  ꥢI/Oߥ٥٥ˤ
	 */
		if (siopcb->siopinib->reg_base == SCIF2_BASE)
			define_int_plevel (IPR17, LEVEL0, 4);
		if ((siopcb->siopinib->reg_base) == SCIF3_BASE)
			define_int_plevel (IPR17, LEVEL0, 0);

}

/*
 *  SIO/SCIFγߥϥɥ
 */
#define	sio_handler_in		sh2scif_isr_in	/*  ߥϥɥ  */
#define	sio_handler_out		sh2scif_isr_out	/*  ߥϥɥ  */
#define	sio_handler_error	sh2scif_isr_error	/*  顼ߥϥɥ  */
#define	sio_handler_brk		sh2scif_isr_brk	/*  ֥졼гߥϥɥ  */
#if TNUM_PORT >= 2
#define	sio_handler2_in		sh2scif_isr2_in	/*  ߥϥɥ  */
#define	sio_handler2_out	sh2scif_isr2_out	/*  ߥϥɥ  */
#define	sio_handler2_error	sh2scif_isr2_error	/*  顼ߥϥɥ  */
#define	sio_handler2_brk	sh2scif_isr2_brk	/*  ֥졼гߥϥɥ  */
#endif /* TNUM_PORT >= 2 */

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr	sh2scif_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr	sh2scif_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr	sh2scif_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr	sh2scif_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_snd	sh2scif_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_rcv	sh2scif_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
