/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh1.h,v 1.8 2004/10/07 17:13:56 honda Exp $
 */

#ifndef _SH1_H_
#define _SH1_H_

/*
 *  ߤΥ٥ֹ
 */
#define GII	 4	/*  ̿:General Illegal Instruction  */
#define SII	 6	/*  å̿:Slot Illegal Instruction */
#define CAE	 9	/*  CPUɥ쥹顼:CPU Address Error       */
#define DAE	10	/*  DMAɥ쥹顼:DMA Address Error       */

#define NMI	11	/*  NMI  		*/
#define USBK	12	/*  桼֥졼  	*/
#define IRQ0	64	/*  ׵  	*/
#define IRQ1	65
#define IRQ2	66
#define IRQ3	67
#define IRQ4	68
#define IRQ5	69
#define IRQ6	70
#define IRQ7	71

	/*  DMAC:쥯ȥꥢȥ  */
#define DEI0	72	/*  DMAC0  */
#define DEI1	74	/*  DMAC1  */
#define DEI2	76	/*  DMAC2  */
#define DEI3	78	/*  DMAC3  */

	/*  ITU:ƥ졼ƥåɥޥѥ륹˥å  */
#define IMIA0	80	/*  ITU0  */
#define IMIB0	81
#define OVI0	82
#define IMIA1	84	/*  ITU1  */
#define IMIB1	85
#define OVI1	86
#define IMIA2	88	/*  ITU2  */
#define IMIB2	89
#define OVI2	90
#define IMIA3	92	/*  ITU3  */
#define IMIB3	93
#define OVI3	94
#define IMIA4	96	/*  ITU4  */
#define IMIB4	97
#define OVI4	98

	/*  SCI:ꥢ륳ߥ˥󥤥󥿡ե  */
#define ERI0	100	/*  SCI0  */
#define RXI0	101
#define TXI0	102
#define TEI0	103
#define ERI1	104	/*  SCI1  */
#define RXI1	105
#define TXI1	106
#define TEI1	107

#define PEI	108	/*  PRT:ХȥΥѥƥ  */
#define ADI	109	/*  A/DС  			*/
#define ITI	112	/*  WDT:åɥå  		*/
#define CMI	113	/*  REF:DRAMեå  		*/



#ifndef _MACRO_ONLY

/*
 *  SH1쥸
 *  
 *  ѥηåǽͭˤ뤿ᡢݥ󥿷ˤ
 *  VPǤϤʤVB *,VH *, VW *ѤƤ롣
 */

/*
 * ԥե󥯥󥳥ȥ ʥ2Хȡ
 */
#define	PAIOR	((VH *)0x5ffffc4)	/*  ݡA I/O쥸  	  */
#define	PACR1	((VH *)0x5ffffc8)	/*  ݡA ȥ쥸1 */
#define	PACR2	((VH *)0x5ffffca)	/*  ݡA ȥ쥸2 */
#define	PBIOR	((VH *)0x5ffffc6)	/*  ݡB I/O쥸  	  */
#define	PBCR1	((VH *)0x5ffffcc)	/*  ݡB ȥ쥸1 */
#define	PBCR2	((VH *)0x5ffffce)	/*  ݡB ȥ쥸2 */
#define	PADR	((VH *)0x5ffffc0)	/*  ݡA ǡ쥸  	  */

#define PBCR1_TD0_RD0_MASK 	~0xfu	/*  TxD0,RxD0üѥޥ	*/
#define PBCR1_TD0 		 0x8u	/*  TxD0üѥޥ  	*/
#define PBCR1_RD0 		 0x2u	/*  RxD0üѥޥ  	*/


/*
 * ߥȥ쥸
 */
#define	IPRA	((VH *)0x5ffff84)	/*  ߥ٥쥸  */
#define	IPRB	((VH *)0x5ffff86)	/*  ʥ2Хȡ  */
#define	IPRC	((VH *)0x5ffff88)
#define	IPRD	((VH *)0x5ffff8a)
#define	IPRE	((VH *)0x5ffff8c)
#define	ICR	((VH *)0x5ffff8e)	/*  ߥȥ쥸  */
					/*  ʥ2Хȡ  */

#endif /* _MACRO_ONLY */

#endif /* _SH1_H_ */
