/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 * åȰ¸ꥢI/O⥸塼(LUXUN2)
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include "s_services.h"

/*
 *  ꥢI/OγߥϥɥΥ٥ֹ
 */
#define INHNO_SERIAL_IN		S1C33_INHNO_SERIAL0RX
#define INHNO_SERIAL_OUT	S1C33_INHNO_SERIAL0TX
#define INHNO_SERIAL_ERR	S1C33_INHNO_SERIAL0ERR

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND		1	/* ǽХå	*/
#define SIO_ERDY_RCV		2	/* ΥХå	*/

#define INDEX_SIO(sioid)	((UINT)((sioid) - 1))

/*
 *  SIOװե饰 ӥåȰ
 */
#define SIO_INT_ERR		0x01
#define	SIO_INT_RCV		0x02
#define	SIO_INT_SND		0x04

/*
 * 顼ե饰 ӥåȰ
 */
#define SIO_ERR_FRAME		0x10
#define SIO_ERR_PARITY		0x08
#define SIO_ERR_OVERRUN		0x04

#ifndef _MACRO_ONLY
/*
 *	ꥢݡȤΥϡɥ¸
 */
typedef struct {
	UB	ch_no;		/* SIOֹͥ		*/
	UB	err_vector;	/* ̿顼ߥ٥ֹ	*/
	UB	rx_vector;	/* ߥ٥ֹ	*/
	UB	tx_vector;	/* λߥ٥ֹ	*/
} SIOPINIB;

/*
 *  ꥢݡȤ֥å
 */
typedef struct {
	const SIOPINIB	*inib;		/* ֥å	*/
	VP_INT		exinf;		/* ĥ		*/
	BOOL		openflag;	/* ץѤߥե饰	*/
	BOOL		tx_cbrflag;	/* Хå¹ԥե饰*/
	BOOL		rx_cbrflag;	/* Хå¹ԥե饰*/
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  ؿλ
 */
extern void	sio_initialize (void);
extern void	sio_ena_cbr(SIOPCB *siopcb, UINT cbrtn);
extern void	sio_dis_cbr(SIOPCB *siopcb, UINT cbrtn);
extern void	serial_handler_in(ID portid);
extern void	serial_handler_out(ID portid);
extern void	sio_ierdy_snd(VP_INT exinf);
extern void	sio_ierdy_rcv(VP_INT exinf);
extern ER	ena_int(INTNO);
extern ER	dis_int(INTNO);

/*
 *  ꥢݡȤν
 */
Inline SIOPCB
*sio_opn_por(ID siopid, VP_INT exinf)
{
	B	temp;

	/*
	 *  ߤζػ
	 */
	if(siopid == 1){
		dis_int(S1C33_INHNO_SERIAL0RX);
		dis_int(S1C33_INHNO_SERIAL0TX);
#ifdef SIO_ERR_HANDLER
		dis_int(S1C33_INHNO_SERIAL0ERR);
#endif
	} else {
		dis_int(S1C33_INHNO_SERIAL1RX);
		dis_int(S1C33_INHNO_SERIAL1TX);
#ifdef SIO_ERR_HANDLER
		dis_int(S1C33_INHNO_SERIAL1ERR);
#endif
	}

	/*
	 *  ꥢI/F
	 *
	 *  8bitĴƱ  ѥƥʤ ȥåץӥå1bit  å
	 */
	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[INDEX_SIO(siopid)].bControl = 0x07;

	((s1c33Port_t *)S1C33_PORT_BASE)->stPPort[INDEX_SIO(siopid)].bFuncSwitch = 0x07;
	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[INDEX_SIO(siopid)].bIrDA = 0x00;

	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[INDEX_SIO(siopid)].bControl = 0xc7;

	/*
	 *  װ򥯥ꥢ
	 */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntFactor[6] |= (0x07 << INDEX_SIO(siopid));

	/*
	 *  ХåեΥꥢ
	 */
	temp = ((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[INDEX_SIO(siopid)].bRxd;

	/*
	 *  
	 */
	siopcb_table[INDEX_SIO(siopid)].openflag = TRUE;
	if(exinf != NULL){
		siopcb_table[INDEX_SIO(siopid)].exinf = exinf;
	}

	/*
	 *  ߤε
	 */
	if(siopid == 1){
		ena_int(S1C33_INHNO_SERIAL0RX);
		ena_int(S1C33_INHNO_SERIAL0TX);
#ifdef SIO_ERR_HANDLER
		ena_int(S1C33_INHNO_SERIAL0ERR);
#endif
	} else {
		ena_int(S1C33_INHNO_SERIAL1RX);
		ena_int(S1C33_INHNO_SERIAL1TX);
#ifdef SIO_ERR_HANDLER
		ena_int(S1C33_INHNO_SERIAL1ERR);
#endif
	}

	return (&(siopcb_table[INDEX_SIO(siopid)]));
}

/*
 *  ̿
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	UB	ch_no;

	ch_no = siopcb->inib->ch_no;
	/*
	 *  žλԤ
	 */
	while(((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bStatus & 0x20){
		;
	}

	/*
	 *  ̿ػߤ
	 */
	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bControl = 0x07;

	return;
}

/*
 *  ǽξ֤
 */
Inline BOOL
sio_get_txready(UB ch_no)
{
	UB	bSioSts;

	bSioSts = ((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bStatus;

	return(!(bSioSts & 0x20));
}

/*
 *  ǽξ֤
 */
Inline BOOL
sio_get_rxready(UB ch_no)
{
	UB	bSioSts;

	bSioSts = ((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bStatus;

	return(bSioSts & 0x01);
}

/*
 *  1ʸɤ߹
 */
Inline INT
sio_rcv_chr(SIOPCB *siopcb)
{
	BOOL	blRxSts;
	UB	ch_no;


	ch_no = siopcb->inib->ch_no;
	blRxSts  = sio_get_rxready(ch_no);

	if(blRxSts){
		return (((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bRxd);
	}

	return (-1);
}

/*
 *  1ʸ񤭹
 */
Inline BOOL
sio_snd_chr(SIOPCB *siopcb, char c)
{
	BOOL	blTxSts;
	UB	ch_no;

	ch_no = siopcb->inib->ch_no;
	blTxSts = sio_get_txready(ch_no);
	if(blTxSts){
		((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bTxd = c;
	}

	return(blTxSts);
}

/*
 *  ꤵ줿SIOͥγװ򥯥ꥢ
 */
Inline void
sio_clr_factor(UB bFlag)
{
	((volatile s1c33Intc_t *) S1C33_INTC_BASE)->bIntFactor[6] |= bFlag;
}

/*  ꤵ줿SIOͥΥ顼ե饰򥯥ꥢ
 *
 */
Inline void
sio_clr_errflag(UB ch_no)
{
	((volatile s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bStatus
		&= ~(SIO_ERR_OVERRUN | SIO_ERR_PARITY | SIO_ERR_FRAME);
}

#endif /* _MACRO_ONLY   */
#endif /* _HW_SERIAL_H_ */
