/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.3 2015/06/28 03:26:19 ssuzuki Exp $
 */

/*
 *	ץå¸⥸塼 ֥RXѡ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ǥѥå
 *
 *  dispatch ϡ߶ػ߾֤ǸƤӽФʤФʤʤ
 *  exit_and_dispatch ⡤߶ػ߾֤ǸƤӽФΤ§Ǥ뤬
 *  ͥ뵯ưб뤿ᡤߥ⡼ɤǸƤӽФˤбƤ롥
 */
	.text
	.globl _dispatch
	.globl _exit_and_dispatch
_dispatch:
	pushm r6-r13                    /* 󥹥å쥸¸ */
	mvfaclo r1
	mvfachi r2
	pushm r1-r2
	mov.l #_runtsk, r1              /* r1  runtsk  */
	mov.l [r1], r1
	mov.l r0, TCB_usp[r1]           /* å¸ */
	mov.l #dispatch_r, TCB_pc[r1]   /* ¹ԺƳϤ¸ */
	bra dispatcher

dispatch_r:
#ifdef SUPPORT_CHG_IPM
	mvfc psw, r1
	and #~0x0f000000, r1		/* PSW  IPL[3:0]  */
	mov.l #_task_intmask, r2	/* task_intmask  */
	mov.l [r2], r2
	or r2, r1
	mvtc r1, psw
#else /* SUPPORT_CHG_IPM */
	mvtipl #0			/* ߵ */
#endif /* SUPPORT_CHG_IPM */
	popm r2-r3
	mvtaclo r2
	mvtachi r3
	popm r6-r13			/* 󥹥å쥸 */
	mov.l TCB_enatex[r1], r2
	btst #TCB_enatex_bit, r2
	bz dispatch_r_1			/* enatex  FALSE ʤ꥿ */
	mov.l TCB_texptn[r1], r2
	tst r2, r2			/* texptn  0 Ǥʤ           */
	bnz _call_texrtn                /*   㳰롼θƽФ */
dispatch_r_1:
	rts

_exit_and_dispatch:
	setpsw	u			/* 桼åݥ󥿤ڤؤ */
dispatcher:
	/*
	 *  Ǥ PSW  U ӥå=1(桼åݥ󥿻)
	 *  I ӥå=0(߶ػ߾)ǤʤФʤʤ
	 */
	mov.l #_schedtsk, r2
	mov.l #_runtsk, r1
	mov.l [r2], [r1]		/* schedtsk  runtsk  */
	mov.l [r1], r1
	tst r1, r1
	bz dispatcher_1			/* runtsk 뤫 */
	mov.l TCB_usp[r1], r0		/* å */
	mov.l TCB_pc[r1], r2		/* ¹ԺƳϤ */
	jmp r2
dispatcher_1:
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ν */
	mvfc psw, r1
	and #~0x0f000000, r1		/* PSW  IPL[3:0]  */
	mov.l #_task_intmask, r2	/* task_intmask  */
	mov.l [r2], r2
	or r2, r1
	mvtc r1, psw
#else /* SUPPORT_CHG_IPM */
	mvtipl #0			/* ߵ */
#endif /* SUPPORT_CHG_IPM */
	wait				/* Ԥʳߥ⡼ɡ */
	/*
	 *  ǳߥ⡼ɤڤ괹Τϡȯ߽
	 *  ˤɤΥåȤȤβȡߥϥɥ
	 *  ΥǥѥåɻߤȤ2Ĥΰ̣롥
	 *
	 *  ץåԤ⡼ɤ˰ܹԤȡߵĤȤϡ
	 *  Բʬ˹ԤʤɬפRX Ǥ wait̿ξԤΤ
	 *  ʤˡԲʬ˹Ԥʤ硤ߤĤ
	 *  ľ˳ߤꡤǥ¹Բǽ֤ˤʤȡ
	 *  ¹Ԥ٤ˤ⤫餺ץåԤ⡼
	 *  ɤˤʤäƤޤ
	 *
	 *  ߤԤĴ֤ϡruntsk  NULL=0ˤꤷʤФʤ
	 *  ʤΤ褦ꤷʤȡߥϥɥ餫 iget_tid 
	 *  ƤӽФݤưͤ˹פʤʤ롥
	 */
	clrpsw i			/* ߶ػ */
	setpsw	u			/* 桼åݥ󥿤ڤؤ */
	mov.l #_reqflg, r1
	mov.l [r1], r2
	tst r2, r2			/* reqflg  FALSE ʤ */
	bz dispatcher_1			/* dispatcher_1  */
	mov.l #0, [r1]			/* reqflg  FALSE  */
	bra dispatcher

/*
 *  ư
 */
	.text
	.globl _activate_r
_activate_r:
	/*
	 *  ưľϥ㳰ػߤƤ뤿ᡤ
	 *  ǥ㳰롼ƤӽФΩʤ
	 */
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ν */
	mvfc psw, r1
	and #~0x0f000000, r1		/* PSW  IPL[3:0]  */
	mov.l #_task_intmask, r2	/* task_intmask  */
	mov.l [r2], r2
	or r2, r1
	mvtc r1, psw
#else /* SUPPORT_CHG_IPM */
	mvtipl #0			/* ߵ */
#endif /* SUPPORT_CHG_IPM */
	setpsw i			/* ߵ */

	mov.l #_ext_tsk, r1		/* Υ꥿󥢥ɥ쥹 */
	push.l r1			/* ext_tsk  */
	mov.l #_runtsk, r1
	mov.l [r1], r1
	mov.l TCB_tinib[r1], r1
	mov.l TINIB_task[r1], r2	/* εưϤ r2  */
	mov.l TINIB_exinf[r1], r1	/* γĥ */
	jmp r2

/*
 *  ߥϥɥ顿CPU㳰ϥɥи
 *
 *  ret_intret_exc ˡI ӥå=0(߶ػ߾)
 *  ƤӽФʤФʤʤ
 */
	.text
	.globl ret_int
	.globl ret_exc
ret_int:
ret_exc:
	setpsw u
	pushm r1-r15
	mvfaclo r1
	mvfachi r2
	pushm r1-r2
	mov.l #_reqflg, r1		/* reqflg  FALSE  */
	mov.l #0, [r1]
	mov.l #_runtsk, r1		/* R1  runtsk */
	mov.l [r1], r1
	mov.l #_enadsp, r2
	mov.l [r2], r2
	tst r2, r2			/* enadsp  FALSE ʤ */
	bz ret_int_1			/*         ret_int_1  */
	mov.l #_schedtsk, r2
	mov.l [r2], r2
	cmp r1, r2			/* runtsk  schedtsk Ʊʤ */
	beq ret_int_1			/*                  ret_int_1  */
	tst r1, r1
	bz dispatcher
	mov.l r0, TCB_usp[r1]		/* å¸ */
	mov.l #ret_int_r, TCB_pc[r1]	/* ¹ԺƳϤ¸ */
	bra dispatcher

ret_int_r:
ret_int_1:
	mov.l TCB_enatex[r1], r2
	btst #TCB_enatex_bit, r2
	bz ret_int_2			/* enatex  FALSE ʤ꥿ */
	mov.l TCB_texptn[r1], r2
	tst r2, r2
	bz ret_int_2			/* texptn  0 ʤ꥿ */
	bsr _call_texrtn		/* 㳰롼θƽФ */
ret_int_2:
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ν */
	mov.l 72[r0], r1
	and #~0x0f000000, r1		/* PSW  IPL[3:0]  */
	mov.l #_task_intmask, r2	/* task_intmask  */
	mov.l [r2], r2
	or r2, r1
	mov.l r1, 72[r0]
#endif /* SUPPORT_CHG_IPM */
	popm r1-r2
	mvtaclo r1
	mvtachi r2
	popm r1-r15			/* 쥸 */
	rte


/**************************************************************
 *  ʲȤΥ󥿡եˤϴޤޤʤȼʬ
 **************************************************************/

/*
 *  no_reg_exception()
 *  CPU㳰ȤϿƤʤ㳰ȯȸƤӽФ롣
 *  㳰ȯPSW,PC,ACC,R0R15Ϥƥͥ
 *  ߤ롣
 * 
 * å¤
 * +0:acc
 * +8:r1
 *+12:r2
 *+16:r3
 *+20:r4
 *+24:r5
 *+28:r6
 *+32:r7
 *+36:r8
 *+40:r9
 *+44:r10
 *+48:r11
 *+52:r12
 *+56:r13
 *+60:r14
 *+64:r15
 *+68:pc
 *+72:psw
 *+76:˻ѤƤåΰ
 */
	.globl _no_reg_exception
_no_reg_exception:
	pushm r1-r15            /*  R1r15¸			*/
	mvfaclo r1              /* 졼¸ */
	mvfachi r2
	pushm r1-r2

	mov.l	r0, r1		/*  				*/
				/*  SP  +76 ǡȯ		*/
	bsr	_cpu_experr	/*  cpu_experr()θƤӽФ		*/
