/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: mpc860_smc.c,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *   MPC860¢ꥢ롦ޥ͡ȥȥSMC1 ʰץɥ饤
 *
 *SMC1Τߤ򥵥ݡȤƤ
 *
 *smc.{c,h}hw_serial.hʬδ
 *smc.{c,h}ꥢǥХ˰¸ʬΤߵ
 *hw_serial.hߥȥ¸
 *
 *åȿ¸ˤĤ
 *ǥХ¸Υѥ᡼mpc860_smc.cѰդ롣
 *縵Υåȿϥѥ륪ץȤͿ
 */

#include <s_services.h>
#include <mpc860_smc.h>

/*
 *  ȥ쥸
 */

/*  SMC⡼ɥ쥸  */
#define SMCMR1          (VH *)(IMMR_BASE + 0xa82)
#define SMCMR_SM_UART   BIT10_16    /*  SMC⡼ɡUART  */
#define SMCMR_TEN       BIT14_16    /*  SMC֥͡  */
#define SMCMR_REN       BIT15_16    /*  SMC֥͡  */


/*
 *  30.2.3 ѥ᡼RAM
 */
/*  ХåեǥץBDƬɥ쥹  */
#define BD1_BASE    (IMMR_BASE + 0x3e80)
#define RBASE1      (VH *)BD1_BASE          /*  RxBD١ɥ쥹  */
#define TBASE1      (VH *)(BD1_BASE+2)      /*  TxBD١ɥ쥹  */
#define RFCR1       (VB *)(BD1_BASE+4)      /*  ե󥯥󥳡  */
					    /*  ХȽʼ  */
#if SIL_ENDIAN == SIL_ENDIAN_BIG	    /* ӥåǥ */
#define RFCR_BO     0x10
#else /* SIL_ENDIAN == SIL_ENDIAN_BIG */    /* ȥ륨ǥ */
#define RFCR_BO	    0x08
#endif /* SIL_ENDIAN == SIL_ENDIAN_BIG */

#define TFCR1       (VB *)(BD1_BASE+5)      /*  ե󥯥󥳡  */
					    /*  ХȽ  */
#if SIL_ENDIAN == SIL_ENDIAN_BIG	    /* ӥåǥ */
#define TFCR_BO     0x10
#else /* SIL_ENDIAN == SIL_ENDIAN_BIG */    /* ȥ륨ǥ */
#define TFCR_BO	    0x08
#endif /* SIL_ENDIAN == SIL_ENDIAN_BIG */

/*
 *  30.3.2 UARTξΥѥ᡼RAM
 */
#define MRBLR1      (VH *)(BD1_BASE+6)      /*  ХåեĹ  */
#define RBPTR1      (VH *)(BD1_BASE+0x10)   /*  RxBDݥ  */
#define TBPTR1      (VH *)(BD1_BASE+0x20)   /*  TxBDݥ  */
                                            /*  祢ɥ륭饯  */
#define MAX_IDL1    (VH *)(BD1_BASE+0x28)
#define IDLC1       (VH *)(BD1_BASE+0x2a)   /*  ɥ롦  */
#define BRKLN1      (VH *)(BD1_BASE+0x2c)   /*  ǽ֥졼Ĺ  */
                                            /*  ֥졼參  */
#define BRKEC1      (VH *)(BD1_BASE+0x2e)
                                    /*  ֥졼ȥ쥸  */
#define BRKCR1      (VH *)(BD1_BASE+0x30)
#define R_MASK1     (VH *)(BD1_BASE+0x32)   /*  ӥåȡޥ  */


/*
 *  ǥ奢ݡȡ˳ݤΰ
 */

/*
 *  ХåեǥץBDΥ١ɥ쥹
 */
#define RxBD_BASE_ADDRESS   0x0     /*  RxBD١ɥ쥹  */
#define TxBD_BASE_ADDRESS   0x8     /*  TxBD١ɥ쥹  */

/*  30.3.10 ѥХåեǥץRxBD  */
#define RxBD        (DUAL_PORT_RAM + RxBD_BASE_ADDRESS)
#define RxBD_STATUS (VH *)RxBD     	/*  ơ  */
#define RxBD_LENGTH (VH *)(RxBD+2) 	/*  ǡĹ  */
#define RxBD_BUFFP  (VW *)(RxBD+4) 	/*  Хåեݥ  */

/*  30.3.11 ѥХåեǥץTxBD  */
#define TxBD        (DUAL_PORT_RAM + TxBD_BASE_ADDRESS)
#define TxBD_STATUS (VH *)TxBD     	/*  ơ  */
#define TxBD_LENGTH (VH *)(TxBD+2) 	/*  ǡĹ  */
#define TxBD_BUFFP  (VW *)(TxBD+4) 	/*  Хåեݥ  */

/*  ѥХåեǥץRxBD  */
/*  ֥ơץեɤ  */
#define RxBD_STATUS_E       BIT0_16     /*    */
#define RxBD_STATUS_W       BIT2_16     /*  å  */
#define RxBD_STATUS_I       BIT3_16     /*    */
#define RxBD_STATUS_CM      BIT6_16     /*  ³⡼  */
#define RxBD_STATUS_ID      BIT7_16     /*  ɥ  */
#define RxBD_STATUS_BR      BIT10_16    /*  ֥졼  */
#define RxBD_STATUS_FR      BIT11_16    /*  ե졼ߥ󥰡顼  */
#define RxBD_STATUS_PR      BIT12_16    /*  ѥƥ顼  */
#define RxBD_STATUS_OV      BIT14_16    /*  С  */

/* ѥХåեǥץTxBD  */
/*  ֥ơץեɤ  */
#define TxBD_STATUS_R       BIT0_16     /*  ǥ  */
#define TxBD_STATUS_W       BIT2_16     /*  å  */
#define TxBD_STATUS_I       BIT3_16     /*    */
#define TxBD_STATUS_CM      BIT6_16     /*  ³⡼  */
#define TxBD_STATUS_P       BIT7_16     /*  ץꥢ֥  */

/*  30.3.12 SMC UART٥ȥ쥸  */
#define SMCE1           (VB *)(IMMR_BASE + 0xa86)
#define SMCE_BRKE       BIT1_8      /*  ֥졼ǽ  */
#define SMCE_BRK        BIT3_8      /*  ֥졼饯  */
#define SMCE_BSY        BIT5_8      /*  ӥ  */
#define SMCE_TX         BIT6_8      /*  Хåե  */
#define SMCE_RX         BIT7_8      /*  Хåե  */

/*  SMC UARTޥ쥸  */
#define SMCM1           (VB *)(IMMR_BASE + 0xa8a)
#define SMCM_BRKE       BIT1_8      /*  ֥졼ǽ  */
#define SMCM_BRK        BIT3_8      /*  ֥졼饯  */
#define SMCM_BSY        BIT5_8      /*  ӥ  */
#define SMCM_TX         BIT6_8      /*  Хåե  */
#define SMCM_RX         BIT7_8      /*  Хåե  */

#define PIC_BUFFER_SIZE     1      		/*  Хåե  */

volatile static UB Rx_buffer[PIC_BUFFER_SIZE];	/*  Хåե  */
volatile static UB Tx_buffer[PIC_BUFFER_SIZE];	/*  Хåե  */


/*
 *  ܡ졼
 *  
 *  Ʊξϡ16åѤΤ16ǳäƤ
 *  ʥ桼16ʬƤ櫓ǤϤʤ
 *  
 */
#define MHZ		1000000

#define BRGC1_CD_VAL		\
	(((SYSTEM_CLOCK * MHZ * 10 + 10) / (16 * BAUD_RATE * 10)) - 1) 

/*  BRGC1쥸CDեɤ20ӥåȤ¤Ƥ  */
#if (BRGC1_CD_VAL & ~0xfffff) != 0
ǥѥ륨顼
#endif


/*
 *  ʬȥӥåȥ졼Ȥ
 *
 */


/*
 *  ܡ졼塢åꤹޤǤԤ
 *  ʺǽ1ӥåʬˡ
 *  BPS=9600bpsξ
 *  t = 1 / BPS = 104,167 = 105,000[nsec]
 */
#define SMC_1BIT_TIME 	105000


/*
 *  ꥢI/Oݡȴ֥å
 *  2chݡȤ˳ĥϽѤΥǡޤ
 */
struct sio_port_control_block {
	VP_INT		exinf;		/* ĥ */
	BOOL		openflag;	/* ץѤߥե饰 */
};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 *  ID = 1 SMC1бƤ롥
 */
static SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))


#define	CODE_LF		0x0a		/*  ԥ  */

/*  饯Ԥ  */
#ifdef DOWNLOAD_TO_RAM      /*  ǥХå  */

#define	DELAY_CH	      0		/*  ̾Υ饯  */
#define	DELAY_LF	5000000		/*  ԥ  */

#else /* DOWNLOAD_TO_RAM */ /*  ROM  */

#define	DELAY_CH	4000000		/*  ̾Υ饯  */
#define	DELAY_LF	1000000		/*  ԥ  */

#endif /* DOWNLOAD_TO_RAM */



/*
 *  ʸǤ뤫
 */
Inline BOOL
smc_getready(SIOPCB *siopcb)
{
	VH status;
	
	status = mpc860_reh_mem(RxBD_STATUS);
	return(!(status & RxBD_STATUS_E));
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
smc_putready(SIOPCB *siopcb)
{
	VH status;

	status = mpc860_reh_mem(TxBD_STATUS);
	return(!(status & TxBD_STATUS_R));
}

/*
 *  ʸμФ
 */
Inline char
smc_getchar(SIOPCB *siopcb)
{
	char c;
	SIL_PRE_LOC;
	
	SIL_LOC_INT();		/*  ߶ػ  */
    	c = Rx_buffer[0];
    	
    	/*  աХåեξΤͭ  */
    	mpc860_orh_mem(RxBD_STATUS, RxBD_STATUS_E);
    	SIL_UNL_INT();		/*  ߵ  */
    	return(c);
}

/*
 *  ʸν
 */
Inline void
smc_putchar(SIOPCB *siopcb, char c)
{
	SIL_PRE_LOC;

	SIL_LOC_INT();		/*  ߶ػ  */
    	Tx_buffer[0] = c;
    	
    	/*  աХåեξΤͭ  */
    	mpc860_orh_mem(TxBD_STATUS, TxBD_STATUS_R);
    	
    	SIL_UNL_INT();		/*  ߵ  */

	/*
	 *  ʸɤᡢԤ֤
	 */
	sil_dly_nse(DELAY_CH);

    	/*  ԥɤξ  */
    	if (c == CODE_LF) {
		sil_dly_nse(DELAY_LF);
	}
}

/*
 *  SIOɥ饤Фν롼
 */
void
smc_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->openflag = FALSE;
	}
}


/*
 *  ץ󤷤ƤݡȤ뤫
 */
BOOL
smc_openflag(void)
{
	return(siopcb_table[0].openflag);
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
smc_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb;

	siopcb = get_siopcb(siopid);
	     					/*    */
	mpc860_andh_mem(SMCMR1, ~(SMCMR_TEN | SMCMR_REN));

	/*
	 *  ԥ󡦥
	 *  ݡB
	 *BP25ԥSMTXD1
	 *BP24ԥSMRXD1
	 */
         				/*  ѥڥե뵡ǽ  */
     	mpc860_orw_mem(PBPAR, (PBPAR_DD24 | PBPAR_DD25));
        				/*  ڥե뵡ǽ0  */
     	mpc860_andw_mem(PBDIR, ~(PBDIR_DR24 | PBDIR_DR25));
        				/*  ƥ֤˥ɥ饤  */
     	mpc860_andw_mem(PBODR, ~(PBODR_OD24 | PBODR_OD25));

    	/*
    	 *  VCOUTBRGCLKؤʬ
    	 *      SCCR.DFBRG=00ʬ棱
    	 */
    	unlock_sccr();          		/*  SCCRå  */
    	mpc860_andw_mem(SCCR, ~SCCR_DFBRG);    	/*  ʬ  */
    	lock_sccr();            		/*  SCCRå  */

    	/*
    	 *  ܡ졼BRG1
    	 *  EN=1BRGȥ֥͡
    	 *  EXTC=00åBRGCLK
    	 *  ATB=0ȥܡǽǥ֥
    	 *  CDʬ
    	 *  DIV1616ʬ뤫ݤ
    	 */
    	mpc860_wrw_mem(BRGC1, BRGC1_EN | (BRGC1_CD_VAL<<1));
    
    	/*
    	 *  BRG1SMC1³
    	 *  SMC1=0NMSI⡼ɡ¿Ųʤ
    	 *  SMC1CS=000åBRG1
    	 */
    	mpc860_andw_mem(SIMODE, ~(SIMODE_SMC1 | SIMODE_SMC1CS));
    
    	/*åꤹޤԤ */
    	sil_dly_nse(SMC_1BIT_TIME);

    	/*
    	 *  ХåեǥץBD
    	 */
    					/*  RxBD١ɥ쥹  */
    	mpc860_wrh_mem(RBASE1, RxBD_BASE_ADDRESS);
         				/*  TxBD١ɥ쥹  */
    	mpc860_wrh_mem(TBASE1, TxBD_BASE_ADDRESS);

    	/*
    	 *  ̿ץåCPINIT RX AND TX PARAMETERSޥɤȯ
    	 */
    	mpc860_CP_command(CPCR_INIT_RX_TX_PARAMETERS, CPCR_CH_NUM_SMC1);
    
    	/*  SDMAUХĴͥ٤  */
    	mpc860_wrw_mem(SDCR, SDCR_RAID_RB5);   /*  ͥ5̾  */

    	/*  ХåեǥץBDΥǥ  */
    	mpc860_wrb_mem(RFCR1, RFCR_BO);		/*    */
    	mpc860_wrb_mem(TFCR1, TFCR_BO);		/*    */
    	    			/*  ХåեĹ  */
    	mpc860_wrh_mem(MRBLR1, PIC_BUFFER_SIZE);
       		/*  ɥ륭饯еǽǥ֥  */
    	mpc860_wrh_mem(MAX_IDL1, 0);
    
    	/*  ֥졼˴ؤɬפʤΤǥꥢ  */
    	mpc860_wrh_mem(BRKLN1, 0);
    	mpc860_wrh_mem(BRKEC1, 0);
    
    	/*  STOP TRANSMITޥɤ֥졼饯ο  */
    	mpc860_wrh_mem(BRKCR1, 1);

    	/*  ХåեǥץRxBDν  */
    	mpc860_wrh_mem(RxBD_STATUS,
                 RxBD_STATUS_E | RxBD_STATUS_W | RxBD_STATUS_I);
                /*  Eե饰å  */
                /*  W=1ơ֥κǽBD  */
                /*  I=1ȯ  */

    	mpc860_wrh_mem(RxBD_LENGTH, PIC_BUFFER_SIZE);  /*  ǡĹ  */
       					/*  Хåեݥ  */
    	mpc860_wrw_mem(RxBD_BUFFP, (VW)Rx_buffer);

    	/*  ХåեǥץTxBDν  */
    	mpc860_wrh_mem(TxBD_STATUS,
    		TxBD_STATUS_R | TxBD_STATUS_W | TxBD_STATUS_I);
                /*  Rե饰å  */
                /*  W=1ơ֥κǽBD  */
                /*  I=1ȯ  */

    	mpc860_wrh_mem(TxBD_LENGTH, PIC_BUFFER_SIZE);  /*  ǡĹ  */
    					/*  Хåեݥ  */
    	mpc860_wrw_mem(TxBD_BUFFP, (VW)Tx_buffer);
    
    	/*  Υ٥Ȥ򥯥ꥢ  */
    	mpc860_wrb_mem(SMCE1,
    		SMCE_BRKE | SMCE_BRK | SMCE_BSY | SMCE_TX | SMCE_RX);

    	/*  ٤ƤUARTߤ  */
    	mpc860_wrb_mem(SMCM1,
     		SMCM_BRKE | SMCM_BRK | SMCM_BSY | SMCM_TX | SMCM_RX);
    
    	/*  SMC⡼  */
    	mpc860_wrh_mem(SMCMR1, (VH)((0x9<<11) | SMCMR_SM_UART));
        	/*  
        	 *  CLEN=9饯Ĺ
        	 *  SL=01ȥåץӥå
        	 *  PEN=0ѥƥʤ
        	 *  SM=10SMC⡼ UART
        	 *  DM=00ǥ⡼ ̾ư
        	 *  TEN=0SMCǥ֥
        	 *  REN=0SMCǥ֥
        	 *   λǤϤޤ⥤֥͡ǤϤʤ
        	 */
    
    	mpc860_orh_mem(SMCMR1, (SMCMR_TEN | SMCMR_REN));
        	/*  
        	 *  嵭˲ä
        	 *  TEN=1SMC֥͡
        	 *  REN=1SMC֥͡
        	 */

	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
smc_cls_por(SIOPCB *siopcb)
{
         					/*    */
	mpc860_andh_mem(SMCMR1, ~(SMCMR_TEN | SMCMR_REN));
	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
smc_snd_chr(SIOPCB *siopcb, char c)
{
	if (smc_putready(siopcb)) {
		smc_putchar(siopcb, c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
smc_rcv_chr(SIOPCB *siopcb)
{
	if (smc_getready(siopcb)) {
		return((INT)(UB) smc_getchar(siopcb));
	}
	return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
smc_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	SIL_PRE_LOC;
	
	switch (cbrtn) {
	case SIO_ERDY_SND:	/* ׵ */
		SIL_LOC_INT();
		mpc860_orh_mem(SMCMR1, SMCMR_TEN);
		SIL_UNL_INT();
		break;
	case SIO_ERDY_RCV:	/* ׵ */
		SIL_LOC_INT();
		mpc860_orh_mem(SMCMR1, SMCMR_REN);
		SIL_UNL_INT();
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
smc_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	SIL_PRE_LOC;

	switch (cbrtn) {
	case SIO_ERDY_SND:	/* ׵ػ */
		SIL_LOC_INT();
		mpc860_andh_mem(SMCMR1, ~SMCMR_TEN);
		SIL_UNL_INT();
		break;
	case SIO_ERDY_RCV:	/* ׵ػ */
		SIL_LOC_INT();
		mpc860_andh_mem(SMCMR1, ~SMCMR_REN);
		SIL_UNL_INT();
		break;
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
smc_isr_siop_out(SIOPCB *siopcb)
{
	/*  SMCE1ǤγװΥåϺѤǤ  */
	
	if (smc_putready(siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		smc_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
smc_isr_siop_in(SIOPCB *siopcb)
{
	/*  SMCE1ǤγװΥåϺѤǤ  */

	if (smc_getready(siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		smc_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  SILѤȤΥǽ
 */
#ifdef SIL_DEBUG
#define ENTER_SMC_ISR						\
	if (sil_debug_on) {					\
		syslog(LOG_EMERG, "Enter selial interrupt.");	\
	}

#else /* SIL_DEBUG */

#define ENTER_SMC_ISR

#endif /* SIL_DEBUG */


/*
 *  SIOߥӥ롼
 *  
 *  
 *  
 */
void
smc_isr()
{
    	UB smce1, smcm1, event;
    	SIL_PRE_LOC;

	ENTER_SMC_ISR
	
    	if (!siopcb_table[0].openflag) goto exit_label;
    
    	smce1 = mpc860_reb_mem(SMCE1);
    	smcm1 = mpc860_reb_mem(SMCM1);
    	event = smce1 & smcm1;
    	
    	if (event & (SMCE_BRKE | SMCE_BRK | SMCE_BSY)) {
    		/*  顼̤  */
    		goto exit_label;
    	}
    	
    	if (event & SMCE_RX) {         /*    */
	        	/*  1򥻥åȤ뤳Ȥˤꡢ٥Ȥ򥯥ꥢ  */
        	mpc860_wrb_mem(SMCE1, SMCE_RX);
        	smc_isr_siop_in(&siopcb_table[0]);
    	}
    	if (event & SMCE_TX) {         /*    */
	        	/*  1򥻥åȤ뤳Ȥˤꡢ٥Ȥ򥯥ꥢ  */
        	mpc860_wrb_mem(SMCE1, SMCE_TX);
        	smc_isr_siop_out(&siopcb_table[0]);
    	}

exit_label:
    	/*
    	 * ׵Υꥢ
    	 *  ߥȥ¸
    	 *  sys_config.h
    	 */
    	SIL_LOC_INT();
	CLEAR_IRQ_TO_ICU(SMC1);	
    	SIL_UNL_INT();
}

/*
 * ݡ󥰤ˤʸ
 */
void
smc_putc_pol(char c)
{
	BOOL is_ten_ok;
	VH smcmr;
	if (smc_openflag()) {	/*  Ƥ뤫å  */
		smcmr = mpc860_reh_mem(SMCMR1);
		is_ten_ok = smcmr & SMCMR_TEN;
		if (!is_ten_ok) {
						/*    */
			mpc860_orh_mem(SMCMR1, SMCMR_TEN);
		}
				/*  ХåեˤʤΤԤ  */
		while(!smc_putready(&siopcb_table[0]));	
		smc_putchar(&siopcb_table[0], c);	/*  1ʸ  */

		if (!is_ten_ok) {
				/*  ХåեˤʤΤԤ  */
			while(!smc_putready(&siopcb_table[0]));
				/*  2饯ʬԤ  */
			sil_dly_nse(SMC_1BIT_TIME*18*10);	
						/*  ػ  */
			mpc860_andh_mem(SMCMR1, ~SMCMR_TEN);
		}
	}
}

/*  end of file  */
