/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *	ޥɥ饤СuPD71054ѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <upd71054.h>

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	INTNO_TIMER0

#ifndef _MACRO_ONLY
/*
 *  ͤɽη
 */
typedef UH		CLOCK;

#endif /* _MACRO_ONLY */

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *  TIMER_CLOCKϡܡɴطΥإåե˵ܤƤ롣
 */
/* 1ߥü(isig_tim ƤӽФ;1kHz)ȯ뤿Υȿ */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
/* clock  usec ñ̤Ѵޥ */
#define	TO_USEC(clock)		((clock) * 1000u / TIMER_CLOCK)

/*
 *  ޼ñ̤ɽѴ
 *  (Ѥ륿ޤ󥫥󥿤ʤΤǡΥޥ)
 */
#define CLOCK_PER_TICK		((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK		((CLOCK) 0xffff)	/* Х */

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE		100u	/* ٤θѤ(ñ̤ɽ) */
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ߤޤǤλ֡nsecñ̡
 *  ͤ˺Ϥʤ
 */
#define	TIMER_STOP_DELAY	200u

#ifndef _MACRO_ONLY

/*
 *  ޳׵Υꥢ
 */
Inline void hw_timer_int_clear() {

	icu_wrb( (VP) ICU_INTR, TIMER0 );
}


/*
 *  ޤεư
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void hw_timer_initialize() {

	upd71054_wrb( (VP) PCNTL, (COUNTER_0 | LOW_HIGH_BYTE | MODE_2 | BINARY) );

	/*
	 *  ޼ꤷޤư򳫻Ϥ롥
	 */
	assert( CLOCK_PER_TICK <= MAX_CLOCK );

	upd71054_wrb( (VP) PCNT0, (UB) LO8(CLOCK_PER_TICK) );
	upd71054_wrb( (VP) PCNT0, (UB) HI8(CLOCK_PER_TICK) );

	/*
	 *  ޳ߤγߥ٥ꤷ׵򥯥ꥢ塤
	 *  ޥ롥
	 */
	all_set_ilv( INHNO_TIMER, &((IPM) IPM_TIMER0) );/* ߥ٥ */

	hw_timer_int_clear();				/* ׵򥯥ꥢ */

	icu_orb( (VP) ICU_INT0M, TIMER0 );		/* ߥޥ */
}

/*
 *  ޤ߽
 *  ޤưߤ롥
 */
Inline void hw_timer_terminate() {

	/*  ޤưߤ  */
	upd71054_wrb( (VP) PCNTL, (COUNTER_0 | LOW_HIGH_BYTE | MODE_2 | BINARY) );

	upd71054_wrb( (VP) PCNT0, 0 );
	upd71054_wrb( (VP) PCNT0, 0 );

	/*
	 *  ޳ߤޥ׵򥯥ꥢ롥
	 */
	icu_andb( (VP) ICU_INT0M, ~TIMER0 );		/* ߤޥ */

	hw_timer_int_clear();				/* ׵򥯥ꥢ */
}

/*
 *  ޤθͤɽФ
 */
Inline CLOCK hw_timer_get_current() {

	UH 	count;
	UB	hi, lo;

	/* ͤɤ߽Ф */
	upd71054_wrb( (VP) PCNTL, (COUNTER_0 | COUNT_LATCH_COMM) );

	lo = upd71054_reb( (VP) PCNT0 );
	hi = upd71054_reb( (VP) PCNT0 );
	count = JOIN8( hi, lo );

	return (CLOCK_PER_TICK - count);
}

/*
 *  ޳׵Υå
 */
Inline BOOL hw_timer_fetch_interrupt() {

	return( ( icu_reb( (VP) ICU_INTR ) & TIMER0 ) != 0);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
