/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *  ץå¸⥸塼MIPS3ѡ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ߥϥɥ顿ߥޥεơ֥
 */
INT_TABLE int_table[ TMAX_ALL_INTNO ];

/*
 *  㳰ϥɥεơ֥
 */
FP exc_table[ TMAX_CORE_EXCNO ];

/*
 *  ץå¸ν
 */
void cpu_initialize() {

	int i;

	/* ߥϥɥ顿ߥޥεơ֥ */
	for( i = 0; i < TMAX_ALL_INTNO; i++ ) {
		define_inh( i, (FP) &cpu_experr );
	}

	/* 㳰٥εơ֥ */
	for( i = 0; i < TMAX_CORE_EXCNO; i++ ) {
		define_exc( i, (FP) &cpu_experr );
	}

}

/*
 *  ץå¸νλ
 */
void cpu_terminate() {
}

/*
 *  Ԥ
 */
void sil_dly_nse(UINT dlytim) {

	/* $2 : v0, $3 : v1 */
	Asm("	move	$2, %0" :: "r"(dlytim) );
	Asm("	li	$3, %0" :: "g"(SIL_DLY_TIM1) );

	Asm("	sub	$2, $2, $3");	/* v0 -= v1 (dlytim -= SIL_DLY_TIM1) */
	Asm("	blez    $2, sil_dly_nse_2");	/* v0 <= 0 ʤ꥿ */

	Asm("	li      $3, %0" :: "g"(SIL_DLY_TIM2) );

	Asm("sil_dly_nse_1:");
	Asm("	sub     $2, $2, $3");	/* v0 -= v1 (dlytim -= SIL_DLY_TIM2) */
	Asm("	bgtz    $2, sil_dly_nse_1");	/* v0 > 0 ʤ롼 */

	Asm("sil_dly_nse_2:");
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ߥޥѹ
 *
 *  ߥޥϡǥѥåˤäơ¹Ծ֤ˤʤä
 *  Ѥ롣Τᡢ¹ˡ̤ΥˤäƳߥޥ
 *  ѹ礬롣JSPͥǤϡߥޥѹϥ㳰
 *  롼ˤäƤⵯ뤬ˤäư񤷤ʤϾʤȻפ
 *  롣ߥޥͤˤäƥǥѥåػߤˤϡ
 *  dis_dsp ʻѤФ褤
 *  MIPS3åȤǤϡMIPS3γߥޥǤʤߥȥ
 *  γߥȥⰷäƤΤա
 */

SYSCALL ER chg_ipm(IPM ipm) {

	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_IPM(ipm);

	t_lock_cpu();
	cpu_set_ipm( ipm.core );	/* MIPS3γߥޥ */
	icu_set_ipm( &(ipm.icu) );	/* ߥȥγߥޥ
					    */
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd);
	return(ercd);
}

/*
 *  ߥޥλ
 */
SYSCALL ER get_ipm(IPM *p_ipm) {

	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	p_ipm->core = cpu_get_ipm();	/* MIPS3γߥޥ */
	icu_get_ipm(&(p_ipm->icu));	/* ߥȥγߥޥ
					   λ */
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*============================================================================*/
/*  ̥ɥȤˤϤʤȼʬ  */

/*
 * ϥɥ餬ϿƤʤߡ㳰ȯȸƤӽФ
 */
void cpu_experr( EXCSTACK *sp, UW SR, UW CR) {

    syslog_0(LOG_EMERG, "Interrupt/Exception error occurs.");

    syslog_1(LOG_EMERG, "PC(EPC;CP0_r14) = 0x%08x",
    			sp->CP0_EPC);
    syslog_2(LOG_EMERG, "SR(Status;CP0_r12) = 0x%08x CR(Cause;CP0_r13) = 0x%08x",
    			SR, CR);	/* SRǤ⡢sp->CP0_StatusǤ */
    syslog_3(LOG_EMERG, "at(r1 ) = %08x v0(r2 ) = %08x v1(r3 ) = %08x",
    			sp->at, sp->v0, sp->v1);
    syslog_4(LOG_EMERG, "a0(r4 ) = %08x a1(r5 ) = %08x a2(r6 ) = %08x a3(r7 ) = %08x",
    			sp->a0, sp->a1, sp->a2, sp->a3);
    syslog_4(LOG_EMERG, "t0(r8 ) = %08x t1(r9 ) = %08x t2(r10) = %08x t3(r11) = %08x",
    			sp->t0, sp->t1, sp->t2, sp->t3);
    syslog_4(LOG_EMERG, "t4(r12) = %08x t5(r13) = %08x t6(r14) = %08x t7(r15) = %08x",
    			sp->t4, sp->t5, sp->t6, sp->t7);
    syslog_2(LOG_EMERG, "t8(r24) = %08x t9(r25) = %08x",
    			sp->t8, sp->t9);
    syslog_2(LOG_EMERG, "HI = %08x LO = %08x",
    			sp->hi, sp->lo);
    syslog_4(LOG_EMERG, "gp(r28) = %08x sp(r29) = %08x fp(r30) = %08x ra(r31) = %08x",
    			sp->gp, sp->sp, sp->fp, sp->ra);
    while(1);
}

/*
 *  ֥å饤֥ʥ󥯥ץǻѡ
 *	(ItIsή)
 *
 *  ؿλͤϡANSI C 饤֥λͤƱɸ饤֥ΤΤ
 *  ȤäΨɤǽ롥
 */
VP _dummy_memcpy(VP dest, VP src, UINT len) {

	VB	*d = dest;
	VB	*s = src;

	while (len-- > 0) {
		*d++ = *s++;
	}

	return(dest);
}
