/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.2 2007/05/28 02:03:55 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼M3A-ZA36ѡ
 */
#include <sys_rename.h>
#include <s_services.h>

#include "jsp_kernel.h"
#include <hw_serial.h>

/*
 *  åȥƥ¸ν
 */
void
sys_initialize()
{
	/* UART */
	sil_wrb_mem((void *)(SIOCR(CONSOLE_PORTID-1)+3), 0);

	/* ݡȤ򳫤(UART0) */
	sil_wrb_mem((void *)PDATA(5), 0);
	sil_wrb_mem((void *)PDIR(5),  0x80);

	/* UART, Non-parity, 1 stop-bit */
	sil_wrb_mem((void *)(SIOMOD0(CONSOLE_PORTID-1)+3), 0);

	/* 8bit, internal clock */
	sil_wrh_mem((void *)(SIOMOD1(CONSOLE_PORTID-1)+2), 0x0800);

	/* M32R(32102) - f(BLK)=10MHz57600bps */
	sil_wrh_mem((void *)(SIOBAUR(CONSOLE_PORTID-1)+2), SERIAL_CLKDIV);
	sil_wrb_mem((void *)(SIORBAUR(CONSOLE_PORTID-1)+3), SERIAL_CLKCMP);

	/* ơꥢ, ư */
	sil_wrb_mem((void *)(SIOCR(CONSOLE_PORTID-1)+2), 0x3);
	sil_wrb_mem((void *)(SIOCR(CONSOLE_PORTID-1)+3), 0x3);

	/* TxD,RxDԥͭ(UART0) */
	sil_wrh_mem((void *)PMOD(5), 0x5500);
}

/*
 *  åȥƥνλ
 */
void
sys_exit(void)
{
	dis_int();
	*(volatile unsigned char *)(ICUIMASK+1) = 0;
	while(1==1)
	{
		/* ϥ⡼ɤذܹ */
		__asm(	"stb	%0, @%1	\n"
				"ldb	%0, @%1 \n"
			  	"nop\nnop\nnop\nnop\nnop\nnop\nnop\nnop"
			: : "r"(1), "r"(CLKMOD+3) );
	}
}

/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
	if(c == '\n')
		sys_putc('\r');
	while( (sil_reb_mem((void *)(SIOSTS(CONSOLE_PORTID-1)+3)) & 0x1) == 0);	/* λԤ */
	sil_wrb_mem((void *)(SIOTXB(CONSOLE_PORTID-1)+3), c);	/* ʸ */
}
