/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.c,v 1.1 2007/05/30 08:38:51 honda Exp $
 */

/*
 *	ꥢI/OǥХSIO˥ɥ饤СM32102¢Ʊꥢѡ
 */

#include <sil.h>
#include <hw_serial.h>

#include <cpu_rename.h>
#include <sys_rename.h>

SIOPCB siopcb_table[TNUM_PORT];

extern FP InterruptHandlerEntry[];

/* 
 *  Ѵؿ 
 */
#define ID_PORT(x)		((x) + 1)
#define INDEX_PORT(x)	((x) - 1)
#define GET_SIOPCB(x)	(&siopcb_table[INDEX_PORT(x)])

/*
 *  ꥢݡȤν
 */
void
sio_initialize(void)
{
	int i;

	for(i=0;i<TNUM_PORT;i++)
	{
		siopcb_table[i].flags = SIO_TYP_M32RUART;
		siopcb_table[i].port  = i;
		siopcb_table[i].exinf = 0;

		InterruptHandlerEntry[INT_SIO0RCV + (siopcb_table[i].port * 2) - 1] = sio_handler_in;
		InterruptHandlerEntry[INT_SIO0XMT + (siopcb_table[i].port * 2) - 1] = sio_handler_out;
	}
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB * siopcb = GET_SIOPCB(siopid);

	siopcb->exinf = exinf;

	switch(SIO_TYP(siopcb->flags)) {
	case SIO_TYP_M32RUART:

		/* UART */
		sil_wrb_mem((void *)(SIOCR(siopcb->port)+3), 0);

		/* ݡȤ򳫤(UART0) */
		sil_wrb_mem((void *)PDATA(5), 0);
		sil_wrb_mem((void *)PDIR(5),  0x80);

		/* UART, Non-parity, 1 stop-bit */
		sil_wrb_mem((void *)(SIOMOD0(siopcb->port)+3), 0);

		/* 8bit, internal clock */
		sil_wrh_mem((void *)(SIOMOD1(siopcb->port)+2), 0x0800);

		/* M32R(32102) - f(BLK)=16MHz115200bps */
		sil_wrh_mem((void *)(SIOBAUR(siopcb->port)+2), SERIAL_CLKDIV);
		sil_wrb_mem((void *)(SIORBAUR(siopcb->port)+3), SERIAL_CLKCMP);

		/* ȯ */
		sil_wrh_mem((void *)(SIOTRCR(siopcb->port)+2), 0x0006);

		/* ơꥢ, ư */
		sil_wrb_mem((void *)(SIOCR(siopcb->port)+2), 0x3);
		sil_wrb_mem((void *)(SIOCR(siopcb->port)+3), 0x3);

		/* ߼յ */
		sil_wrh_mem((void *)(ICUCR(SIO,siopcb->port)+2), 0x1000);
		sil_wrh_mem((void *)(ICUCR(SIO,siopcb->port)+6), 0x1000);

		/* TxD,RxDԥͭ(UART0) */
		sil_wrh_mem((void *)PMOD(5), 0x5500);

		break;
	}

	return siopcb;
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sio_cls_por(SIOPCB *siopcb)
{
	switch(SIO_TYP(siopcb->flags))
	{
	case SIO_TYP_M32RUART:
		/* ưػߤ */
		sil_wrb_mem((void *)(SIOCR(siopcb->port)+3), 0);
		break;
	}
}

/*
 *  ꥢI/OݡȤʸ
 */
INT sio_rcv_chr(SIOPCB * siopcb)
{
	switch(SIO_TYP(siopcb->flags))
	{
	case SIO_TYP_M32RUART:
		return sil_reb_mem((void *)(SIORXB(siopcb->port)+3));
	}

	return -1;
}


/*
 *  ʸå
 */

inline BOOL
hw_port_getready(SIOPCB *p)
{
	switch(SIO_TYP(p->flags))
	{
	case SIO_TYP_M32RUART:
		return (sil_reb_mem((void *)(SIOSTS(p->port)+3)) & 0x4) != 0 ? TRUE : FALSE;
	}
	return FALSE;
}

/*
 *  ꥢI/OݡȤΥХå
 */
void sio_ena_cbr(SIOPCB * siopcb, UINT cbrtn)
{}

/*
 *  ꥢI/OݡȤΥХåػ
 */
void sio_dis_cbr(SIOPCB * siopcb, UINT cbrtn)
{}

void sio_handler_in(void)
{
	int port;

	for(port = 0; port < TNUM_PORT; ++ port)
	{
		if( hw_port_getready(&siopcb_table[port]) == TRUE )
			sio_ierdy_rcv(GET_SIOPCB(ID_PORT(port))->exinf);
	}
}

void sio_handler_out(void)
{
	int port;

	for(port = 0; port < TNUM_PORT; ++ port)
	{
		if((siopcb_table[port].flags & SIO_STS_SENDING) != 0)
		{
			/* ơ */
			sil_wrb_mem((void *)(SIOCR(port)+2), 0x1);
			siopcb_table[port].flags &= ~SIO_STS_SENDING;

			sio_ierdy_snd(GET_SIOPCB(ID_PORT(port))->exinf);
		}
	}
}
