/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: start.S,v 1.14 2007/07/27 11:28:44 honda Exp $
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"	

	.section ".boot","ax"
	.global reset
reset:
_reset_handler:
	xor     r0, r0, r0
	wcsr    IE, r0
    mvhi    r1, hi(_reset_handler)
    ori     r1, r1, lo(_reset_handler)
    wcsr    EBA, r1
    calli   _start
	nop
	nop
_breakpoint_handler:
	sw      (sp+0), ra
	calli   _save_all
	ori     r1, r0, 1
	calli   _process_exception
	bi      _restore_all_and_bret
	nop
	nop
	nop
_instruction_bus_error_handler:
	sw      (sp+0), ra
	calli   _save_all
	ori     r1, r0, 2
	calli   _process_exception
	bi      _restore_all_and_eret
	nop 
	nop
	nop
_watchpoint_handler:
	sw      (sp+0), ra
	calli   _save_all
	ori     r1, r0, 3
	calli   _process_exception
	bi      _restore_all_and_bret
	nop 
	nop
	nop
_data_bus_error_handler:
	sw      (sp+0), ra
	calli   _save_all
	ori     r1, r0, 4
	calli   _process_exception
	bi      _restore_all_and_eret
	nop 
	nop
	nop
_divide_by_zero_handler:
	sw      (sp+0), ra
	calli   _save_all
	ori     r1, r0, 5
	calli   _process_exception
	bi      _restore_all_and_eret
	nop 
	nop
	nop
_interrupt_handler:
	sw      (sp+0), ra
	calli   _save_all
	ori     r1, r0, 6
	calli   _process_exception
	bi      _restore_all_and_eret
	nop 
	nop
	nop
_system_call_handler:
	sw      (sp+0), ra
	calli   _save_all
	ori     r1, r0, 7
	calli   _process_exception
	bi      _restore_all_and_eret
	nop 
	nop
	nop

	.global _start
_start:
    /* Clear r0 */
    xor     r0, r0, r0
    /* Initialize the cache */
    wcsr    icc, r1
    nop
    nop
    nop
    nop
    wcsr    dcc, r1
    nop
    nop
    nop
    nop
    /* clear the interrupt */
    wcsr    ie, r0
    wcsr    im, r0
    mvhi    r1, 0xFFFF
    ori     r1, r1, 0xFFFF
    wcsr    ip, r1
    /* Setup stack and global pointer */
    mvhi    sp, hi(_fstack)
    ori     sp, sp, lo(_fstack)
    mvhi    gp, hi(_gp)
    ori     gp, gp, lo(_gp)
    /* Clear BSS */
    mvhi    r1, hi(_fbss)
    ori     r1, r1, lo(_fbss)
    mvhi    r3, hi(_ebss)
    ori     r3, r3, lo(_ebss)
clear_bss:
    be      r1, r3, start_kernel
    sw      (r1+0), r0
    addi    r1, r1, 4
    bi      clear_bss
start_kernel:	        
	calli kernel_start
