/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#include <h8s_sci.h>

/*
 *  H8S¢SCI ʰSIOɥ饤
 *  ϡͥѤ˵ҤƤ롣H8S꡼ˤϡͥ
 *    ʾ奵ݡȤƤåפ⤢뤬ΤȤбưפǤ롣
 */

/* TNUM_SIOP : ݡȤ륷ꥢݡȤο (ǥե 2)
   TNUM_PORT : ݡȤ륷ꥢI/OݡȤο (ǥե 2)
   (sys_config.h ˵) */

/* ʲǡ쥸Υɥ쥹UW إ㥹Ȥ򤷤Ƥ롣ϡ١
   ɥ쥹˥եåͤäơǽŪʥ쥸Υɥ쥹Ƥ
   Ǥ롣ˡǽŪ VP ˥㥹ȤƤ롣(h8s_sci.h) */

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	UW	reg_base;	/* 쥸Υ١ɥ쥹 */
	UB	smr_def;	/* SMR  b6-b3;
				   (ӥåȿȥåץӥåȡѥƥ) */
	UB	boud_brr_def;	/* BRR ͡ʥܡ졼Ȥ͡ */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT		exinf;		/* ĥ */
	BOOL		openflag;	/* ץѤߥե饰 */
	BOOL		getready;	/* ʸ */
	BOOL		putready;	/* ʸǤ */
};

/*
 *  ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ (UW)	SCI0_BASE_ADDR,
	  (UB)	0,
	  (UB)	BRR_RATE		/* N  */
	},
#if TNUM_SIOP >= 2
	{ (UW)	SCI1_BASE_ADDR,
	  (UB)	0,
	  (UB)	BRR_RATE		/* N  */
	}
#endif /* TNUM_SIOP >= 2 */
};

/*
 *  ꥢI/OݡȽ֥åμФ
 */
#define INDEX_SIOPINIB(siopid)	((UINT)((siopid) - 1))
#define get_siopinib(siopid)	(&(siopinib_table[INDEX_SIOPINIB(siopid)]))

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SCIѥ쥸ؿ
 */
Inline void
h8s_sci_or( const SIOPINIB *siopinib, UW reg, UB val )
{
	h8s_sci_wrb( siopinib->reg_base, reg, h8s_sci_reb( siopinib->reg_base, reg ) | val );
}

Inline void
h8s_sci_and( const SIOPINIB *siopinib, UW reg, UB val )
{
	h8s_sci_wrb( siopinib->reg_base, reg, h8s_sci_reb( siopinib->reg_base, reg ) & val );
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
h8s_sci_getready(SIOPCB *siopcb)
{
	siopcb->getready = FALSE;
	if( h8s_sci_reb( siopcb->siopinib->reg_base, (UW) SSR ) & RDRF )
		siopcb->getready = TRUE;

	return( siopcb->getready );
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
h8s_sci_putready(SIOPCB *siopcb)
{
	siopcb->putready = FALSE;
	if( h8s_sci_reb( siopcb->siopinib->reg_base, (UW) SSR ) & TDRE )
		siopcb->putready = TRUE;

	return( siopcb->putready );
}

/*
 *  ʸμФ
 */
Inline char
h8s_sci_getchar(SIOPCB *siopcb)
{
	/* RDRFꥢ */
	h8s_sci_and( siopcb->siopinib, (UW) SSR, (UB) ~RDRF );

	return( (char) h8s_sci_reb( siopcb->siopinib->reg_base, (UW) RDR ) );
}

/*
 *  ʸν
 */
Inline void
h8s_sci_putchar(SIOPCB *siopcb, char c)
{
#ifndef GDB_STUB
	h8s_sci_wrb( siopcb->siopinib->reg_base, (UW) TDR, c );

	/* TDREꥢ */
	h8s_sci_and( siopcb->siopinib, (UW) SSR, (UB) ~TDRE );
#else
	stub_putc( c );
#endif
}

/*
 *  SIOɥ饤Фν롼
 */
void
h8s_sci_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 *  SIO쥸롼
 */
void
h8s_sci_init_siopinib( const SIOPINIB  *siopinib )
{
	/*
	 * SCI쥸ν
	 */

	/*  */
	h8s_sci_and( siopinib, (UW) SCR, (UB) ~( TE | RE ) );

	/* ӥåĹʤ */
	h8s_sci_wrb( siopinib->reg_base, (UW) SMR, siopinib->smr_def );

	/* ܡ졼 */
	h8s_sci_wrb( siopinib->reg_base, (UW) BRR, siopinib->boud_brr_def );

	/* ߶ػߤȥå */
	h8s_sci_and( siopinib, (UW) SCR, (UB) ~( TIE | RIE | MPIE | TEIE | CKE1 | CKE0 ) );

	/* ܡ졼Ȥΰ경(1bitʬԤ) */
	sil_dly_nse( 1/BAUD_RATE );

	/* 顼ե饰򥯥ꥢ */
	h8s_sci_and( siopinib, (UW) SSR, ~( ORER | FER | PER ) );

	/* ġߵ */
	h8s_sci_or( siopinib, (UW) SCR, ( RIE | TE | RE ) );
}

/*
 *  ͥ뵯ưΥСʡѤν
 */
void
h8s_sci_init(void)
{
	h8s_sci_init_siopinib( get_siopinib(1) );
#if TNUM_SIOP >= 2
	h8s_sci_init_siopinib( get_siopinib(2) );
#endif /* TNUM_SIOP >= 2 */
}

/*
 *  ץ󤷤ƤݡȤ뤫
 */
BOOL
h8s_sci_openflag(void)
{
#if TNUM_SIOP < 2
	return( siopcb_table[0].openflag );
#else /* TNUM_SIOP < 2 */
	return( siopcb_table[0].openflag || siopcb_table[1].openflag );
#endif /* TNUM_SIOP < 2 */
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
h8s_sci_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB 		*siopcb = get_siopcb(siopid);
	const SIOPINIB  *siopinib = siopcb->siopinib;

#ifndef GDB_STUB
	/* SCI쥸ν */
	h8s_sci_init_siopinib( siopinib );
#endif	/* GDB_STUB */

	/* ߥ٥ꡢ׵᥯ꥢϡsio_opn_por ǹԤ */

	siopcb->exinf = exinf;
	siopcb->getready = siopcb->putready = FALSE;
	siopcb->openflag = TRUE;

	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
h8s_sci_cls_por(SIOPCB *siopcb)
{
	/* TEND  1 ˤʤޤԤ */
	while ( !(h8s_sci_reb( siopcb->siopinib->reg_base, (UW) SSR ) & TEND ) );

	h8s_sci_and( siopcb->siopinib, (UW) SCR, ~( TE | RE ) );
	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
h8s_sci_snd_chr(SIOPCB *siopcb, char c)
{
	if( h8s_sci_putready(siopcb) ) {
		h8s_sci_putchar(siopcb, c);
		siopcb->putready = FALSE;
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
h8s_sci_rcv_chr(SIOPCB *siopcb)
{
	if( h8s_sci_getready(siopcb) ) {
		siopcb->getready = FALSE;
		return( (INT)(UB) h8s_sci_getchar(siopcb) );
			/* UB Υ㥹Ȥϡĥɻߤ뤿 */
	}

	return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
h8s_sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		h8s_sci_or( siopcb->siopinib, (UW) SCR, TIE );
		return;
	case SIO_ERDY_RCV:
		h8s_sci_or( siopcb->siopinib, (UW) SCR, RIE );
		return;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
h8s_sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch( cbrtn ) {
	case SIO_ERDY_SND:
		h8s_sci_and( siopcb->siopinib, (UW) SCR, (UB) ~TIE );
		return;
	case SIO_ERDY_RCV:
		h8s_sci_and( siopcb->siopinib, (UW) SCR, (UB) ~RIE );
		return;
	}
}

/*
 *  SIOγߥӥ롼 (SCI0)
 */
void
h8s_sci0_isr_in()
{
	SIOPCB *siopcb = get_siopcb(1);

	/* ΥХå롼θƤӽФ */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_rcv( siopcb->exinf );
	}
}

void
h8s_sci0_isr_out()
{
	SIOPCB *siopcb = get_siopcb(1);

	/* ǽХå롼θƤӽФ */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_snd( siopcb->exinf );
	}
}

/*
 *  SIOμ顼ߥӥ롼 (SCI0)
 *
 *  顼ϡ顼ե饰ΥꥢΤߡ
 *  С󥨥顼ե졼ߥ󥰥顼ѥƥ顼
 */
void
h8s_sci0_isr_error(void)
{
	SIOPCB *siopcb = get_siopcb(1);

	if( siopcb->openflag ) {
		/*  顼ե饰ꥢ  */
		h8s_sci_and( siopcb->siopinib, (UW) SSR, ~( RDRF | ORER | FER | PER ) );
	}
}

/*
 *  SIOγߥӥ롼 (SCI1)
 */
void
h8s_sci1_isr_in()
{
	SIOPCB *siopcb = get_siopcb(2);

	/* ΥХå롼θƤӽФ */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_rcv( siopcb->exinf );
	}
}

void
h8s_sci1_isr_out()
{
	SIOPCB *siopcb = get_siopcb(2);

	/* ǽХå롼θƤӽФ */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_snd( siopcb->exinf );
	}
}

/*
 *  SIOμ顼ߥӥ롼 (SCI1)
 *
 *  顼ϡ顼ե饰ΥꥢΤߡ
 *  С󥨥顼ե졼ߥ󥰥顼ѥƥ顼
 */
void
h8s_sci1_isr_error(void)
{
	SIOPCB *siopcb = get_siopcb(2);

	if( siopcb->openflag ) {
		/*  顼ե饰ꥢ  */
		h8s_sci_and( siopcb->siopinib, (UW) SSR, ~( RDRF | ORER | FER | PER ) );
	}
}

/*
 *  H8S ¢ SCI ѥݡ󥰽 (LOGTASK_PORTIDѡsys_putc)
 */
void
h8s_sci0_putchar_pol( char c )
{

	const SIOPINIB  *siopinib = get_siopinib( LOGTASK_PORTID );

	/* TDRE  1 ˤʤޤԤ */
	while ( !(h8s_sci_reb( siopinib->reg_base, (UW) SSR ) & TDRE ) );

	h8s_sci_wrb( siopinib->reg_base, (UW) TDR, (UB) c );

	/* TDREꥢ */
	h8s_sci_and( siopinib, (UW) SSR, (UB) ~TDRE );

	/* TEND  1 ˤʤޤԤ */
	while ( !(h8s_sci_reb( siopinib->reg_base, (UW) SSR ) & TEND ) );
}
