/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *  H8S¢SCI ʰSIOɥ饤
 *  ϡͥѤ˵ҤƤ롣H8S꡼ˤϡͥ
 *    ʾ奵ݡȤƤåפ⤢뤬ΤȤбưפǤ롣
 */

#include <h8s_sci.h>

/* SCI쥸Υɥ쥹 */
/* ١ɥ쥹 */
#define SCI0_BASE_ADDR	0xff78	/* ͥ룰 */
#define SCI1_BASE_ADDR	0xff80	/* ͥ룱 */
#define SCI2_BASE_ADDR	0xff88	/* ͥ룲 */

/* 쥸եå */
#define SMR		0	/* ꥢ⡼ɥ쥸 */
#define BRR		1	/* ӥåȥ졼ȥ쥸 */
#define SCR		2	/* ꥢ륳ȥ쥸 */
#define TDR		3	/* ȥ󥹥ߥåȥǡ쥸 */
#define SSR		4	/* ꥢ륹ơ쥸 */
#define RDR		5	/* 쥷֥ǡ쥸 */
#define SCMR		6	/* ޡȥɥ⡼ɥ쥸 */

/* ƥ쥸Υӥåȥѥ */

/* RSR, RDR, TSR, TDR */
/* ٤Τϡä̵ */

/* SMR */
#define CA	BIT7
#define	CHR	BIT6	/* 8bit = 0 / 7bit = 1 */
#define	PE	BIT5	/* Parity OFF = 0 / Parity ON = 1 */
#define	OE	BIT4	/* EVEN Parity = 0 / ODD Parity = 1 */
#define	STOP	BIT3	/* 1 STOP BIT = 0 / 2 STOP BIT = 1 */
#define MP	BIT2
#define	CSK1	BIT1
#define	CSK0	BIT0

/*
 *SMRν
 *
 *ӥå7=0ĴƱ⡼
 *ӥå6=0饯󥰥=8ӥå
 *ӥå5=0ѥƥղáåػ
 *ӥå4ѥƥ⡼ɡ̤ѡ
 *ӥå3=0ȥåץӥåȥ󥰥1ӥå
 *ӥå1,0ܡ졼ȥͥ졼ؤΥå
 *ܡɰ¸SCRn_CKSȤnchֹ
 */
#define SMR_INIT	0

/* SCR */
#define TIE	BIT7
#define	RIE	BIT6
#define	TE	BIT5
#define	RE	BIT4
#define	MPIE	BIT3
#define TEIE	BIT2
#define	CKE1	BIT1
#define	CKE0	BIT0

/* SSR */
#define TDRE	BIT7
#define	RDRF	BIT6
#define	ORER	BIT5
#define	FER	BIT4
#define	PER	BIT3
#define TEND	BIT2
#define	MPB	BIT1
#define	MPBT	BIT0


/* 
 * TNUM_PORT : ꥢɥ饤Сserial.cˡĤޤ GDIC٥ǥݡȤ
 * ꥢݡȤο 
 * TNUM_SIOP : PDIC٥ʥץå¢SIOˤǥݡȤ륷ꥢI/Oݡ
 * οʸߤμǤϺ3
 *  
 *user_config.h롣
 */

/* ʲǡ쥸Υɥ쥹UW إ㥹Ȥ򤷤Ƥ롣ϡ١
   ɥ쥹˥եåͤäơǽŪʥ쥸Υɥ쥹Ƥ
   Ǥ롣ˡǽŪ VP ˥㥹ȤƤ롣(h8s_sci.h) */

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	UW	reg_base;	/* 쥸Υ١ɥ쥹 */
	UH	boud_rate;	/* ܡ졼[bps]*/
	UB	boud_brr_def;	/* BRR ͡ʥܡ졼Ȥ͡ */
	UB	smr_def;	/* SMR 
				   (ӥåȿȥåץӥåȡѥƥ) */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT		exinf;		/* ĥ */
	BOOL		openflag;	/* ץѤߥե饰 */
	BOOL		getready;	/* ʸ */
	BOOL		putready;	/* ʸǤ */
};

/*
 *  ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ (UW)SCI0_BASE_ADDR,
	  (UH)BAUD_RATE1,
	  (UB)BRR0_RATE,			/* N  */
	  (UB)(SMR_INIT | (SCR0_CKS & (CKE1 | CKE0)))
	},
#if TNUM_SIOP >= 2
	{ (UW)SCI1_BASE_ADDR,
	  (UH)BAUD_RATE1,
	  (UB)BRR1_RATE,			/* N  */
	  (UB)(SMR_INIT | (SCR1_CKS & (CKE1 | CKE0)))
	}
#endif /* TNUM_SIOP >= 2 */
#if TNUM_SIOP >= 3
	,{(UW)SCI2_BASE_ADDR,
	  (UH)BAUD_RATE2,
	  (UB)BRR2_RATE,			/* N  */
	  (UB)(SMR_INIT | (SCR2_CKS & (CKE1 | CKE0)))
	}
#endif /* TNUM_SIOP >= 3 */
};

/*
 *  ꥢI/OݡȽ֥åμФ
 */
#define INDEX_SIOPINIB(siopid)	((UINT)((siopid) - 1))
#define get_siopinib(siopid)	(&(siopinib_table[INDEX_SIOPINIB(siopid)]))

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SCIѥƥ।󥿥ե쥤
 *
 *   base : ݡȤΥ١ɥ쥹
 *   offset : 쥸եå
 *   val : 쥸 
 */
#define h8s_sci_wrb( base, offset, val ) h8s_wrb_reg( (base) + (offset), (val) )
#define h8s_sci_reb( base, offset )	h8s_reb_reg( (base) + (offset) )

/*
 *  SCIѥ쥸ؿ
 */
Inline void
h8s_sci_or( const SIOPINIB *siopinib, INT offset, INT val )
{
	UB reg = h8s_sci_reb( siopinib->reg_base, offset );
	h8s_sci_wrb( siopinib->reg_base, offset, reg | (UB)val );
}

Inline void
h8s_sci_and( const SIOPINIB *siopinib, INT offset, INT val )
{
	UB reg = h8s_sci_reb( siopinib->reg_base, offset );
	h8s_sci_wrb( siopinib->reg_base, offset, reg & (UB)val );
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
h8s_sci_getready(SIOPCB *siopcb)
{
	UB ssr;
	
	siopcb->getready = FALSE;
	ssr =  h8s_sci_reb( siopcb->siopinib->reg_base, SSR );
	if( ssr & RDRF ) {
		siopcb->getready = TRUE;
	}
	return( siopcb->getready );
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
h8s_sci_putready(SIOPCB *siopcb)
{
	siopcb->putready = FALSE;
	if( h8s_sci_reb( siopcb->siopinib->reg_base, SSR ) & TDRE ) {
		siopcb->putready = TRUE;
	}
	return( siopcb->putready );
}

/*
 *  ʸμФ
 */
Inline char
h8s_sci_getchar(SIOPCB *siopcb)
{
	/* RDRFꥢ */
	h8s_sci_and( siopcb->siopinib, SSR, ~RDRF );

	return( (char) h8s_sci_reb( siopcb->siopinib->reg_base, RDR ) );
}

/*
 *  ʸν
 */
Inline void
h8s_sci_putchar(SIOPCB *siopcb, char c)
{
	h8s_sci_wrb( siopcb->siopinib->reg_base, TDR, c );

	/* TDREꥢ */
	h8s_sci_and( siopcb->siopinib, SSR, ~TDRE );
}

/*
 *  SIOɥ饤Фν롼
 */
void
h8s_sci_initialize(void)
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 *  SIO쥸롼
 */
void
h8s_sci_init_siopinib( const SIOPINIB  *siopinib )
{
	/*
	 * SCI쥸ν
	 */

	/*  */
	h8s_sci_and( siopinib, SCR, ~( TE | RE ) );

	/* ӥåĹʤ */
	h8s_sci_wrb( siopinib->reg_base, SMR, siopinib->smr_def );

	/* ܡ졼 */
	h8s_sci_wrb( siopinib->reg_base, BRR, siopinib->boud_brr_def );

	/*
	 *  ߶ػߤȥå
	 *åå
	 */
	h8s_sci_and( siopinib, SCR, ~( TIE | RIE | MPIE | TEIE | CKE1 | CKE0 ) );

	/* ܡ졼Ȥΰ경(1bitʬԤ) */
	sil_dly_nse_long( 1000000000ul / (siopinib->boud_rate) );

	/* 顼ե饰򥯥ꥢ */
	h8s_sci_and( siopinib, SSR, ~( ORER | FER | PER ) );	/*  */

	/* ġߵ */
	h8s_sci_or( siopinib, SCR, ( RIE | TE | RE ) );
}


/*
 *  SCI0̷⤬ʤå
 */
#if defined(OMIT_SCI0) && (POL_PORTID == 1)
#error h8s_sci_putchar_pol serial port ID error.
#endif

/*
 *  ͥ뵯ưΥСʡѤν
 */
void
h8s_sci_init(void)
{
	h8s_sci_init_siopinib( get_siopinib(POL_PORTID) );
}

/*
 *  ץ󤷤ƤݡȤ뤫
 */
BOOL
h8s_sci_openflag(void)
{
	BOOL ret;
#ifndef OMIT_SCI0
	ret = siopcb_table[0].openflag;
#else /* OMIT_SCI0 */
	ret = FALSE;
#endif /* OMIT_SCI0 */

#if TNUM_SIOP >= 2
	ret |= siopcb_table[1].openflag;
#endif /* TNUM_SIOP >= 2 */

#if TNUM_SIOP >= 3
	ret |= siopcb_table[2].openflag;
#endif /* TNUM_SIOP >= 3 */

	return(ret);
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
h8s_sci_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB 		*siopcb = get_siopcb(siopid);
	const SIOPINIB  *siopinib = siopcb->siopinib;

	/* SCI쥸ν */
	h8s_sci_init_siopinib( siopinib );

	/* ߥ٥ꡢ׵᥯ꥢϡsio_opn_por ǹԤ */

	siopcb->exinf = exinf;
	siopcb->getready = siopcb->putready = FALSE;
	siopcb->openflag = TRUE;

	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
h8s_sci_cls_por(SIOPCB *siopcb)
{
	/* TEND  1 ˤʤޤԤ */
	while ( !(h8s_sci_reb( siopcb->siopinib->reg_base, SSR ) & TEND ) );

	h8s_sci_and( siopcb->siopinib, SCR, ~( TE | RE ) );	/*  */
	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
h8s_sci_snd_chr(SIOPCB *siopcb, char c)
{
	if( h8s_sci_putready(siopcb) ) {
		h8s_sci_putchar(siopcb, c);
		siopcb->putready = FALSE;
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
h8s_sci_rcv_chr(SIOPCB *siopcb)
{
	if( h8s_sci_getready(siopcb) ) {
		siopcb->getready = FALSE;
		return( (INT)(UB) h8s_sci_getchar(siopcb) );
			/* UB Υ㥹Ȥϡĥɻߤ뤿 */
	}

	return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
h8s_sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		h8s_sci_or( siopcb->siopinib, SCR, TIE );
		return;
	case SIO_ERDY_RCV:
		h8s_sci_or( siopcb->siopinib, SCR, RIE );
		return;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
h8s_sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch( cbrtn ) {
	case SIO_ERDY_SND:
		h8s_sci_and( siopcb->siopinib, SCR, ~TIE );
		return;
	case SIO_ERDY_RCV:
		h8s_sci_and( siopcb->siopinib, SCR, ~RIE );
		return;
	}
}

/*
 *  SIOγߥӥ롼
 *ͥ붦ʬ򥤥饤ؿȤƤ
 */
Inline void
h8s_scix_isr_in(ID portid)
{
	SIOPCB *siopcb = get_siopcb(portid);

	/* ΥХå롼θƤӽФ */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_rcv( siopcb->exinf );
	}
}

Inline void
h8s_scix_isr_out(ID portid)
{
	SIOPCB *siopcb = get_siopcb(portid);

	/* ǽХå롼θƤӽФ */
	if( siopcb->openflag ) {
		h8s_sci_ierdy_snd( siopcb->exinf );
	}
}

/*
 *  SIOμ顼ߥӥ롼
 *ͥ붦ʬ򥤥饤ؿȤƤ
 *
 *  顼ϡ顼ե饰ΥꥢΤߡ
 *  С󥨥顼ե졼ߥ󥰥顼ѥƥ顼
 */
Inline void
h8s_scix_isr_error(INT portid)
{
	SIOPCB *siopcb = get_siopcb(portid);

	if( siopcb->openflag ) {
		/*  顼ե饰ꥢ  */
		h8s_sci_and( siopcb->siopinib, SSR, ~( RDRF | ORER | FER | PER ) );
	}
}


#ifndef OMIT_SCI0
/*
 *  SIOγߥӥ롼 (SCI0)
 */
void
h8s_sci0_isr_in(void)
{
	h8s_scix_isr_in(1);
}

void
h8s_sci0_isr_out(void)
{
	h8s_scix_isr_out(1);
}

/*
 *  SIOμ顼ߥӥ롼 (SCI0)
 */
void
h8s_sci0_isr_error(void)
{
	h8s_scix_isr_error(1);
}

#endif /*  OMIT_SCI0  */

#if TNUM_SIOP >=2
/*
 *  SIOγߥӥ롼 (SCI1)
 */
void
h8s_sci1_isr_in(void)
{
	h8s_scix_isr_in(2);
}

void
h8s_sci1_isr_out(void)
{
	h8s_scix_isr_out(2);
}

/*
 *  SIOμ顼ߥӥ롼 (SCI1)
 */
void
h8s_sci1_isr_error(void)
{
	h8s_scix_isr_error(2);
}
#endif /* TNUM_SIOP >=2 */

#if TNUM_SIOP >=3
/*
 *  SIOγߥӥ롼 (SCI2)
 */
void
h8s_sci2_isr_in(void)
{
	h8s_scix_isr_in(3);
}

void
h8s_sci2_isr_out(void)
{
	h8s_scix_isr_out(3);
}

/*
 *  SIOμ顼ߥӥ롼 (SCI2)
 */
void
h8s_sci2_isr_error(void)
{
	h8s_scix_isr_error(3);
}
#endif /* TNUM_SIOP >=3 */


/*
 *  H8S ¢ SCI ѥݡ󥰽 (POL_PORTIDѡsys_putc)
 */
void
h8s_sci_putchar_pol( char c )
{

	const SIOPINIB  *siopinib = get_siopinib( POL_PORTID );

	/* TDRE  1 ˤʤޤԤ */
	while ( !(h8s_sci_reb( siopinib->reg_base, SSR ) & TDRE ) );

	h8s_sci_wrb( siopinib->reg_base, TDR, c );

	/* TDREꥢ */
	h8s_sci_and( siopinib, SSR, ~TDRE );

	/* TEND  1 ˤʤޤԤ */
	while ( !(h8s_sci_reb( siopinib->reg_base, SSR ) & TEND ) );
}
