/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *      ץå¸⥸塼H8Sѡ
 *ͥǻѤ
 *ǡޥؿΥץȥ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>


/*
 *  ץåϢ
 */
#include <h8s.h>
#include <h8s_sil.h>


/*
 *  ץåü̿Υ饤ؿ
 *    ǡMAX_IPMѤƤΤǡɤ߹
 */
#include <cpu_insn.h>

/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define TBIT_TCB_TSTAT          8       /* tstat եɤΥӥå */
#define TBIT_TCB_PRIORITY       8       /* priority եɤΥӥå */

/*
 *  ƥȥ֥å
 */
#ifndef _MACRO_ONLY

typedef struct task_context_block {
	VP	sp;		/* åݥ */
	FP	pc;		/* ץ५ */
} CTXB;

#endif /* _MACRO_ONLY */

/*
 *  ƥֻ
 */
#ifndef _MACRO_ONLY

/*
 *  ߥͥȥ
 *    ͥȥ󥿤ͤǥƥȤȽǤԤΤǡƥȻȻ
 *    Ѥ롣
 */

extern volatile UB	intnest;

/*
 *  ƥȻ
 *    ߥͥȥ󥿤ɤ߽Фľ˳ߤȯƤ⡢äȤˤ
 *    ƥȤ⸵äƤ
 */

Inline BOOL
sense_context(void)
{
	BOOL ret;
	
	ret = (intnest != 0) ? TRUE : FALSE;
	return(ret);
}

/*
 *  CPUå֤λ
 */

/*
 *  CPUå֤ɽե饰
 *  ߶ػߡʥͥγߤΤߡ
 *  
 *  iscpulocked == TRUE
 *  ΤȤCPUå֤Ȥ롣
 */
extern volatile BOOL     iscpulocked;

#define sense_lock()    iscpulocked

#endif /* _MACRO_ONLY */

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

#ifndef _MACRO_ONLY

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  ʤˤϡt_unlock_cpu  task_intmask  0 ֤Ƥ褤
 */

#ifdef SUPPORT_CHG_IPM
extern volatile IPM	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(void)
{
	disint();		/* cpu_insn.h */
        iscpulocked = TRUE;
}

Inline void
t_unlock_cpu(void)
{
        iscpulocked = FALSE;
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿ᡣ
	 *   task_intmask 񤭴뤳ȤϤʤ
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();		/* cpu_insn.h */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern volatile IPM	int_intmask;	/* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu(void)
{
	IPM	intmask;

	/*
	 *  ѿ intmask ȤäƤΤϡcurrent_intmask()Ƥľ
	 *  ߤȯư줿ߥϥɥ int_intmask ѹ
	 *  ǽ뤿Ǥ롣
	 */
	intmask = current_intmask();
	disint();		/* cpu_insn.h */
	int_intmask = intmask;
        iscpulocked = TRUE;
}

Inline void
i_unlock_cpu(void)
{
        iscpulocked = FALSE;
	set_intmask(int_intmask);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.src
 *    dispatch ϡƥȤƤӽФ줿ӥǡ
 *    CPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.src
 *    exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ
 *    H8SǤϡߥ٥ơ֥ROMľܤ֤뤿ᡢ
 *ʤ
 *ʥ٥ơ֥perlץȤ
 */

Inline void define_inh(INHNO inhno, FP inthdr) {
}

/*
 *  CPU㳰ϥɥ
 *    H8SǤϡCPU㳰εʤᡢʤ
 */

Inline void define_exc(EXCNO excno, FP exchdr) {
}

#endif /* _MACRO_ONLY */

/*
 *  ߥϥɥν
 *H8CH8S¸Ǥϳߤν򥢥֥饽
 *뤿ᡢCɬפʤ
 *Ǥ϶ȤΥ󥿡ե碌뤿ᡢ
 *ɬפʥޥΤߤƤ롣
 */

/*
 *  C롼δؿ̾Υ٥
 *H8CH8¸Ǥvector.srcΥ롦ܥ
 *ǤΤǡХ˸ɬפʤ
 *Ǥ϶ȤΥ󥿡ե碌뤿ᡢ
 *ߡΥ٥ͿƤ롣
 */
#define INT_ENTRY(inthdr) _kernel_common_interrupt_process
#define EXC_ENTRY(exchdr) _kernel_common_interrupt_process

/*
 *  ߥϥɥνޥ
 *CǤϤޤǤʤᡢ֥饽
 *Ѱդ롣
 */
#define INTHDR_ENTRY(inthdr) extern void INT_ENTRY(inthdr)(void)

/*
 *  CPU㳰ϥɥνޥ
 */
#define EXCHDR_ENTRY(exchdr) extern void EXC_ENTRY(exchdr)(void)

/*
 *  CPU㳰ȯΥƥ֤λ
 */
#ifndef _MACRO_ONLY

/*
 *  CPU㳰ȯΥƥȽ
 *    H8SǤǤϡƤФ뤳Ȥ̵󥿡ե򤽤뤿ᡢ
 *Ƥ롣
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
        return(TRUE);
}

/*
 *  CPU㳰ȯCPUå֤λ
 *    H8SǤǤϡƤФ뤳Ȥ̵󥿡ե򤽤뤿ᡢ
 *Ƥ롣
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return(TRUE);
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY_ */

/*============================================================================*/
/*  ̥ɥȤˤϤʤȼʬ  */

/*
 *  ߥ٥ѥޥʤ⤷ϡ饤ؿ
 *  ipr : 󥿥ץȥץ饤ƥ쥸( IPRA - IPRK ) 16ӥå
 *  mask : IPRѥޥʾ̤̤( IPR_UPR, IPR_LOW )
 *  level : ߥ٥( 0 - 7 )
 */
#ifndef _MACRO_ONLY

Inline void icu_set_ilv( UH ipr, BOOL mask, INT level ) {
	UB val;
	
	if( mask == IPR_UPR ) {
		val = (UB)(( h8s_reb_reg( ipr ) & ~IPR_UPR_MASK ) | TO_HI4((UB) level));
		h8s_wrb_reg( ipr, val );
	} else if( mask == IPR_LOW ) {
		val = (UB)(( h8s_reb_reg( ipr ) & ~IPR_LOW_MASK ) | TO_LO4((UB) level));
		h8s_wrb_reg( ipr, val );
	}
}

/*
 *  ̤ȯΥ顼 (cpu_config.c, cpu_support.src)
 */

/*
 * åƬƥ쥸ΤޤǤΥեå
 * 
 * 
 * ɥХ󥹥ɥ⡼
 * ⡼ɣ
 * 
 * å¤
 * +0:er0
 * +4:er1
 * +8:er2
 *+12:er3
 *+16:er4
 *+20:er5
 *+24:er6
 *+28:exr
 *+29:ꥶ
 *+30:crr
 *+31:pc
 *+34:˻ѤƤåΰ
 */

#ifndef __2000A__
#error support Advanced mode only.(Normal mode isn't supported)
#endif

/*
 * ȯľΥåݥ󥿤ޤǤΥեå
 * ̤ȯ
 */
#define OFFSET_SP	34

/*
 *  ̤ȯΥ顼ϻΥå¤
 */
typedef struct exc_stack {
	UW	er0;
	UW	er1;
	UW	er2;
	UW	er3;
	UW	er4;
	UW	er5;
	UW	er6;
	UB	exr;
	UB	dummy;
	UW	pc;	/*  ץࡦ  	*/
} EXCSTACK;


extern void	cpu_experr(EXCSTACK *sp);

#endif /* _MACRO_ONLY_ */

#endif /* _CPU_CONFIG_H_ */
