/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: cpu_insn.h,v 1.7 2007/03/23 07:58:33 honda Exp $
 */

#ifndef _CPU_INSN_H_
#define _CPU_INSN_H_

/*
 *      ץåü̿δؿH8ѡ
 */

#include <machine.h>	/*  ϤȤ߹ߴؿ  */

/*
 *  ǥ󥳡ɥ쥸CCRˤθͤɽФ
 *UB current_ccr(void);
 *unsigned char get_ccr(void);
 */
#define current_ccr	get_ccr

/*
 *  ǥ󥳡ɥ쥸CCRˤθͤѹ
 *Ȥ߹ߴؿset_ccr()򤽤Τޤ޻Ȥ
 *void set_ccr(unsigned char ccr);
 */

/*
 *  NMI٤Ƥγߤػ
 */
#define disint()	or_ccr(CCR_DISINT_ALL)

/*
 *  ٤Ƥγߤ
 */
#define enaint()	and_ccr(CCR_ENAINT_ALL)

/*
 * ӥåȥåȤȥӥåȥꥢ
 */

/*
 * ӥåȥѥȥޥѥ
 */
#define H8BIT2PATTERN(bit)	(0x1u << (UINT)(bit))
#define H8BIT2MASK(bit)		((~H8BIT2PATTERN(bit)) & 0xffu)

/*
 * ӥåȤ򥻥å
 */
#define bitset(p, bit)	((*(volatile UB *)(p)) |= (UB)H8BIT2PATTERN(bit))

/*
 * ӥåȤ򥯥ꥢ
 */
#define bitclr(p, bit)	((*(volatile UB *)(p)) &= (UB)H8BIT2MASK(bit))


#endif /* _CPU_INSN_H_ */
