/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by  Advanced Data Controls, Corp
 *                2009 by Suikan
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *  CPU¸ޥ⥸塼CQ-FRK-NXP-ARMѡ
 *  TIMER3
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include "lpc2388.h"




/*
 *  ޳ߤγֹ
 */
#define    INHNO_TIMER    INHNO_TIMER3

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UW    CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *  TIMER_CLOCK ϥåȥܡ
 */
#define TO_CLOCK(nume, deno) (LP2388_SYSTEM_TIMER3_CLOCK/1000 * (nume) / (deno))
#define TO_USEC(clock)       ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK    ((CLOCK) 0xffffffff)
/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define GET_TOLERANCE    100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ޤεư
 *
 * ޤŪʥ޳׵ȯ롥ޡ3ȥޥå쥸0Ȥ
 * PCLK (Hz)򥯥åϤȤƻȤ
 */
Inline void
hw_timer_initialize()
{

    /*
     *  ޴Ϣ
     */
    		/* ߤӥꥻå */
    T3TCR = 0x0002;
    		/* ߤΥꥢ  */
    T3IR =  0x0001;				/* MR0ߤΥꥢ */

	T3CTCR = 0;			/* PCLKΥå롣ץϤ̵ */
	T3PR = 0;			/* PCLKΥå򤹤٤ƿ롣ץꥹʤ */
    T3MR3 = (LP2388_SYSTEM_TIMER3_CLOCK/1000) -1;		/* 1mSȤ˥ޥå */
	T3MCR = 0x3 << 9;	/* MR3S:R:I = 0:1:1ޥå饫󥿤ꥻåȤߤ򤫤 */

	T3TCR = 1;			/* TIMER3򥫥ȳϤˤ */

		/* ޡߤͭˤ */
	VICIntEnable = 1<< INHNO_TIMER;
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
    		/* ߤΥꥢ  */
	T3IR = 1<<3;			/* MR3ޥåγߤ򥯥ꥢ */
}

/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate()
{
    		/* ߤӥꥻå */
    T3TCR = 0x0002;
    		/* ߤΥꥢ  */
    T3IR =  0x0001;				/* MR0ߤΥꥢ */
}

/*
 *  ޤθͤɤߤ
 *
 *  ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
    return(T3TC);
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
    return(T3IR & (1<<3));		/* MR3 ޥåƤ鿿 */
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */



