/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2009 by Suikan
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *  ꥢI/OǥХSIO˥ɥ饤СCQ-FRK-NXP-ARM UARTѡ
 *
 *   ΥեϡTOPPERS/JSP 1.4.2 config/sh3/ms7727cp01/hw_serial.h
 *   ͡षμ̻ҤѹΤǤ롣
 */
#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

#include "lpc2388uart.h"
#include "lpc2388.h"


/*
 *  SIOɥ饤Фν롼
 */
#define sio_initialize  uart_initialize

#ifndef _MACRO_ONLY
/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB  *siopcb;
    BOOL    openflag;

    /*
     *  ץ󤷤ݡȤ뤫 openflg ɤǤ
     */
    openflag = uart_openflag();

    /*
     *  ǥХ¸Υץ
     */
    siopcb = uart_opn_por(siopid, exinf);

    /*
     * бߤΥ֥͡
     * ݡ1,2,3ФLPC2388U0, U2, U3Ƥ롣U1ϻȤʤ
     */
    switch(siopid-1)
    {
    case 0:
    	ena_int(INTNO_U0);
    	break;
    case 1:
    	ena_int(INTNO_U2);
    	break;
    case 2:
    	ena_int(INTNO_U3);
    	break;
    }

    return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
    /*
     *  ǥХ¸Υ
     */
    uart_cls_por(siopcb);
}


/*
 *  SIOγߥϥɥ
 */
#define sio0_rx_handler uart0_rx_isr
#define sio0_tx_handler uart0_tx_isr

/*
 *  ꥢI/OݡȤؤʸ
 */
#define sio_snd_chr uart_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define sio_rcv_chr uart_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define sio_ena_cbr uart_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define sio_dis_cbr uart_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define sio_ierdy_snd   uart_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define sio_ierdy_rcv   uart_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
