/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: fc_binutils.cpp,v 1.21 2004/09/04 15:50:13 honda Exp $
 */

#if defined(FILECONTAINER_BINUTILS) || defined(TESTSUITE)

#ifdef _MSC_VER
#pragma warning(disable:4786) //ǥХåʸ255ʸڤͤ᤿
#endif

#include "base/filecontainer.h"
#include <string>
#include <map>
#include <fstream>
#include <cassert>
#include <cctype>
#include <cstdio>
#include <cstdlib>
#include <cstring>

#define _isspace(x)  isspace(x)
#define _isprint(x)  isprint(x)

#define SIZE_LOADPAGE 65536         //ХʥǡǼڡñ

#define SIZE_TO_CONFIRM_BINARYFILE 128  //ե뤬ХʥޤफɤǧΤɤ߽ФǡĹ (ХåեΤǤޤ礭ʤ)

#define MAGIC_SYMBOL "_checker_magic_number"
#define MAGIC_NUMBER 0x01234567                         //4ХȤ

#define CMD_GNUNM      "nm"
#define CMD_GNUOBJCOPY "objcopy"

#define MAKE_BASEADDRESS(x)   ((x) & ~(SIZE_LOADPAGE-1))
#define MAKE_OFFSETADDRESS(x) ((x) &  (SIZE_LOADPAGE-1))

using namespace std;

namespace {

    class FileContainerBinutilsImpl : public FileContainer
    {
    public:
        typedef void (interceptor_func_t)(fstream &, const string &);      //԰դˬ줿Хʥեνбؿη

    protected:
        string                 symbol_prefix;
        map<string, address_t> symbol_table;
        map<address_t, char *> contents;

        address_t last_address;     //åɤ
        char *    last_page;

            //ǡ
        void loadSymbols(fstream & file)  throw(Exception);
        void loadDataContents(fstream & file) throw(Exception);

            //contents1ХȽ񤭹
        void writeByte(address_t address, unsigned int) throw(Exception);

            //ư
        void searchSymbolPrefix(void) throw();
        void searchByteOrder(void)    throw();

    public:
        FileContainerBinutilsImpl(void) throw();
        virtual ~FileContainerBinutilsImpl(void) throw();

            /* 󥿥ե */
        virtual void        attachModule(const string & filename) throw(Exception);
        virtual void        loadContents(void * dest, address_t address, size_t size) throw(Exception);
        virtual address_t   getSymbolAddress(const string & symbol) throw(Exception);
        virtual std::string getArchitecture(void) throw();

        TESTSUITE_PROTOTYPE(main)
    };

    namespace {
        FileContainerBinutilsImpl instance_of_FileContainerBinutilsImpl;
    }

        /* 󥹥ȥ饯 */
    FileContainerBinutilsImpl::FileContainerBinutilsImpl(void) throw()
        : symbol_prefix(""), symbol_table(), contents(), last_address(0), last_page(0)
    {}

        /* ǥȥ饯 : ǡХåեβ */
    FileContainerBinutilsImpl::~FileContainerBinutilsImpl(void) throw()
    {
        map<address_t, char *>::iterator scope;

        scope = contents.begin();
        while(scope != contents.end()) {
            delete [] scope->second;
            ++ scope;
        }
        symbol_table.clear();
        contents.clear();
    }

        /* ե̾򥫥ޤĤʬ */
    void splitFilename(const string & src, string & first, string & second) throw(Exception)
    {
        if(!src.empty()) {
            string::size_type pos;

            pos = src.find_first_of(',');
            if(pos != string::npos) {
                first  = src.substr(0, pos);
                second = src.substr(pos + 1);
            }
            else {
                    //ե̾ĤꤵƤʤ
                first  = src;
                second = src;
            }
        }
        else
            ExceptionMessage("[FCBI] Empty filename could not be accepted.","[FCBI] ե̾ޤ").throwException();
    }

        /* ե뤬ХʥǡäƤ뤫ɤȽ */
    bool hasBinaryContents(fstream & file) throw()
    {
        assert(file.is_open());

        bool        result = false;
        char        buffer[SIZE_TO_CONFIRM_BINARYFILE];
        streamsize  length;

        file.read(buffer, SIZE_TO_CONFIRM_BINARYFILE);
        length = file.gcount();

        for(streamsize i = 0; i < length; ++ i) {
            if(buffer[i] < 0 || !(_isprint(buffer[i]) || _isspace(buffer[i]))){
                result = true;
                break;
            }
        }

		if(!result) {
	        file.clear();
    	    file.seekg(0, ios::beg);    //ƬᤷƤ
		}

        return result;
    }

        /* ƥȥե򳫤 (Хʥäˤн) */
    void openTextFile(fstream & file, const string & filename, FileContainerBinutilsImpl::interceptor_func_t * interceptor) throw(Exception)
    {
        assert(!filename.empty());
        assert(!file.is_open());

        file.open(filename.c_str(), ios::in|ios::binary);
        if(!file.is_open()) {
            ExceptionMessage("File '%' could not be opened.","ե '%' ϳޤ") << filename << throwException;
            return;
        }

            /* Хʥեä... */
        while(hasBinaryContents(file)) {
            file.close();
            
            if(interceptor != 0) {
                (*interceptor)(file, filename);
                interceptor = 0;    //нϰΤ
            }

            if(!file.is_open()) {
                break;
            }
        }

            /* ե뤬ʤä㳰 */
        if(!file.is_open())
            ExceptionMessage("Program failed to convert the binary '%' into suitable style. Please specify a suitable TEXT file.",
                            "ץϥХʥե'%'Ѵ˼ԤޤƥȥեꤷľƤ")
                                << filename << throwException;
    }

        /* Ūʥե̾ */
    const char * makeTemporaryFilename(void) throw()
    {
        static char filename[10];

        sprintf(filename, "cfg%06x", (int)(rand() & 0xffffffl));

        return filename;
    }


        /* ХʥGNU-NMȤäѴ */
    void interceptWithGnuNM(fstream & file, const string & filename) throw(Exception)
    {
        assert(!file.is_open());

        string cmdline;
        string symfile;

        symfile.assign(makeTemporaryFilename());
        cmdline = string(CMD_GNUNM) + " " + filename + " > " + symfile;
        VerboseMessage("[EXEC] %\n") << cmdline;

		system(cmdline.c_str());

            /* ե */
        file.open(symfile.c_str(), ios::in);
        if(file.is_open()) {
            remove(symfile.c_str());
        }
    }

        /* ХʥGNU-OBJCOPYȤäѴ */
    void interceptWithGnuObjcopy(fstream & file, const string & filename) throw(Exception)
    {
        assert(!file.is_open());

        string cmdline;
        string srecfile;

        srecfile.assign(makeTemporaryFilename());
        cmdline = string(CMD_GNUOBJCOPY) + " -F srec " + filename + " " + srecfile;
        VerboseMessage("[EXEC] %\n") << cmdline;

		system(cmdline.c_str());

            /* ե */
        file.open(srecfile.c_str(), ios::in);
        if(file.is_open()) {
            remove(srecfile.c_str());
        }
    }

        /* 16ʤ10ʤؤѴ (ݥ󥿰ư, Ĺդ) */
    unsigned int hextodec(const char * & src, size_t length) throw()
    {
        assert(length <= sizeof(unsigned int) * 2);

        unsigned int result = 0;
        unsigned int digit;

        while(length-- > 0) {
            if(*src >= '0' && *src <= '9')
                digit = *src - '0';
            else if(*src >= 'A' && *src <='F')
                digit = *src - 'A' + 10;
            else if(*src >= 'a' && *src <='f')
                digit = *src - 'a' + 10;
            else
                break;

            ++ src;
            result = (result << 4) | (digit & 0xf);
        }

        return result;
    }

        /* NMϤԤѡ */
    bool readGnuNmLine(fstream & file, FileContainer::address_t & address, string & attribute, string & symbolname) throw()
    {
        assert(file.is_open());

        string src;
        string addr;
        string::size_type pos1;
        string::size_type pos2;

            /* ȤˤƤ */
        address = 0;
        if(!attribute.empty())
            attribute.erase();
        if(!symbolname.empty())
            symbolname.erase();

            //ιԤ (, ̤ܥɤФ)
        do {
            if(file.eof())
                return false;

            getline(file, src, '\n');
        } while(src.empty() || src.at(0) == ' ');

            //Ԥʬ
        pos1 = src.find_first_of(' ');
        addr = src.substr(0, pos1);

        pos2 = src.find_first_of(' ', pos1 + 1);
        attribute  = src.substr(pos1 + 1, pos2 - pos1 - 1);
        symbolname = src.substr(pos2 + 1);

            //ɥ쥹Υѡ  ( : ʤǤʤޤޤäƤ뤫Ȥȡɥ쥹32bitĶ륿åȤ뤫)
        while(!addr.empty()) {
            size_t length = addr.size();
            const char * src = addr.c_str();
            if(length > sizeof(unsigned int) * 2)
                length = sizeof(unsigned int) * 2;
            address = (address << (length * 2)) | (hextodec(src, length));
            addr.erase(0, length);
        }

        return true;
    }

        /* ܥɤ߹ */
    void FileContainerBinutilsImpl::loadSymbols(fstream & file) throw(Exception)
    {
        assert(file.is_open());

        address_t address;
        string    attribute;
        string    symbolname;

        while(readGnuNmLine(file, address, attribute, symbolname)) {
            symbol_table.insert(map<string, address_t>::value_type(symbolname, address));
        }

		VerboseMessage("% symbols loaded\n") << symbol_table.size() << &throwException;

        file.close();
    }

        /* contents1ХȽ񤭹 */
    void FileContainerBinutilsImpl::writeByte(address_t address, unsigned int value) throw(Exception)
    {
        address_t & base = last_address;
        char *    & page = last_page;

            /* åɤȤʤʤ顢ڡõ */
        if(MAKE_BASEADDRESS(address) != last_address || last_page == 0) {
            map<address_t, char *>::iterator scope;

            base  = MAKE_BASEADDRESS(address);
            scope = contents.find(base);
            if(scope == contents.end()) {
                page = new(nothrow) char [SIZE_LOADPAGE];
                if(page == 0) {
                    ExceptionMessage("Not enough memory available to store the contents","­ΤᡢǡγǼ˼Ԥޤ").throwException();
                    return;
                }
                contents.insert(map<address_t,char*>::value_type(base, page));
            }
            else
                page = scope->second;
        }

        *(page + (address - base)) = static_cast<char>(value & 0xff);
    }

        /* ζʸڤ */
    void trimString(string & src) throw()
    {
        string::size_type pos;

        pos = src.find_last_not_of(" \t\r\n");
        if(pos != string::npos && pos != src.size())
            src.erase(pos + 1);
    }

        /* ȥS쥳ɤɤ߹ */
        /*
                The general format of an S-record follows: 
                +-------------------//------------------//-----------------------+
                | type | count | address  |            data           | checksum |
                +-------------------//------------------//-----------------------+
        */
    bool readRecord(fstream & file, string & dest) throw(Exception)
    {
        unsigned int sum;
        unsigned int count;
        unsigned int i;
        const char * pos;

            /* ιԤɤ߹ */
        do {
                //getlineReadFileƤǥ֥åΤǡμ¤EOFȿ뤿ˤ
            int ch = file.get();
            if(ch == EOF)
                return false;

            file.putback(static_cast<char>(ch));
            getline(file, dest);
        } while(dest.empty());

        trimString(dest);

            /* Ƚ */

        if(dest[0] != 'S')      //Ƭ'S'ǻϤޤʤ
            ExceptionMessage("The file is not a Motorola S-Record file.","ȥSեޥåȤ̵ԤĤޤ") << throwException;

        pos = dest.c_str() + 2;
        count = hextodec(pos, 2);
        if(dest.size() != (count + 2)*2)
            ExceptionMessage("Illegal S-Record found (count unmatched).","S쥳ɤޤ (԰)") << throwException;

        sum = count;
        for(i = 0; i < count; ++ i)
            sum += hextodec(pos, 2);

        if((sum & 0xff) != 0xff)
            ExceptionMessage("Illegal S-Record found (check-sum unmatched).","S쥳ɤޤ (å԰)") << throwException;

        return true;
    }

        /* γϥɥ쥹 */
    FileContainer::address_t parseRecordAddress(const string & src, FileContainer::address_t base) throw()
    {
        const char * record = src.c_str();
        FileContainer::address_t result = 0;

        record += 4;
        switch(*(record - 3)) {
            case '1':
                result = hextodec(record, 4);
                break;
            case '2':
                result = hextodec(record, 6);
                break;
            case '3':
                result = hextodec(record, 8);
                break;
            case '5':
                result = base;
                break;
            default:
                break;
        }

        return result;
    }

        /* ǡʬĤƥå */
    void chopRecord(string & src) throw()
    {
        string::size_type start;

        switch(src[1]) {
            case '1':  start = 4 + 4;  break;
            case '2':  start = 4 + 6;  break;
            case '3':  start = 4 + 8;  break;
            default:   start = 4;      break;
        }

            //Ƭ4Х + ɥ쥹 + ǸΥ
        src = src.substr(start, src.size() - start - 2);
    }

        /* ץǡɤ߹ */
    void FileContainerBinutilsImpl::loadDataContents(fstream & file) throw(Exception)
    {
        assert(file.is_open());

        address_t address;
        string    line;

        address = 0;
        while(readRecord(file, line)) {

            address = parseRecordAddress(line, address);

            chopRecord(line);

                /* ǡγǼ */
            const char * pos = line.c_str();
            while(*pos != '\x0') {
                unsigned int data = hextodec(pos, 2);
                writeByte(address, data);
                ++ address;
            }
        }

        file.close();
    }

        /* ܥץեμưȽ */
    void FileContainerBinutilsImpl::searchSymbolPrefix(void) throw()
    {
        const char *  candidate_list[] = {"", "_", NULL};
        const char ** candidate;

        for(candidate = candidate_list; *candidate != NULL; ++ candidate) {
            map<string, address_t>::const_iterator scope;
            string symbol;
            
            symbol = string(*candidate) + MAGIC_SYMBOL;
            scope  = symbol_table.find(symbol);

            if(scope != symbol_table.end())
                break;
        }

        if(*candidate != NULL)
            symbol_prefix.assign(*candidate);
    }

        /* ǥμưȽ */
    void FileContainerBinutilsImpl::searchByteOrder(void) throw()
    {
        address_t address;
        union {
            char         buffer[4];
            unsigned int value;
        };

        try {
            value   = 0;
            address = getSymbolAddress(MAGIC_SYMBOL);
            loadContents(buffer, address, 4);

            if(value == MAGIC_NUMBER) {
                byteorder = HOSTORDER;
            }
            else {
                buffer[0] ^= buffer[3], buffer[3] ^= buffer[0], buffer[0] ^= buffer[3]; // swap(buffer[0], buffer[3])
                buffer[1] ^= buffer[2], buffer[2] ^= buffer[1], buffer[1] ^= buffer[2]; // swap(buffer[1], buffer[2])

                if(value == MAGIC_NUMBER)
                    byteorder = HOSTORDER == LITTLE ? BIG : LITTLE;
                else
                    throw false;
            }
        }
        catch(...) {}
    }

        /* ⥸塼Υå -> ܥɽФ, ǡǼ */
    void FileContainerBinutilsImpl::attachModule(const string & filename) throw(Exception)
    {
        fstream file;
        string  symbol_filename;
        string  contents_filename;

        splitFilename(filename, symbol_filename, contents_filename);

        openTextFile(file, symbol_filename, interceptWithGnuNM);
        loadSymbols(file);

        openTextFile(file, contents_filename, interceptWithGnuObjcopy);
        loadDataContents(file);

        searchSymbolPrefix();
        searchByteOrder();
    }

        /* ǼƤƤμ */
    void FileContainerBinutilsImpl::loadContents(void * _dest, address_t address, size_t size) throw(Exception)
    {
        char * dest = static_cast<char *>(_dest);

        while(size > 0) {
            map<address_t, char *>::const_iterator scope;

            address_t  base   = MAKE_BASEADDRESS(address);
            address_t  offset = MAKE_OFFSETADDRESS(address);
            size_t     transfer_size = size;

            if(transfer_size > SIZE_LOADPAGE - offset)
                transfer_size = SIZE_LOADPAGE - offset;

            scope = contents.find(base);
            if(scope == contents.end())
                ExceptionMessage("[Internel error] Memory read with unmapped address","[顼] ޥåפƤʤɥ쥹Ȥäƥ꡼ɤԤޤ").throwException();

            memcpy(dest, scope->second + offset, transfer_size);

            dest += transfer_size;
            size -= transfer_size;
        }
    }

        /* ܥΥɥ쥹μ */
    FileContainer::address_t FileContainerBinutilsImpl::getSymbolAddress(const string & symbol) throw(Exception)
    {
        string symbolname;
        map<string, address_t>::const_iterator scope;

        symbolname = symbol_prefix + symbol;

        scope = symbol_table.find(symbolname);
        if(scope == symbol_table.end())
            ExceptionMessage("Unknown symbol '%'","ʥܥ̾ '%'") << symbol << throwException;

        return scope->second;
    }

        /* ƥ̾μ */
    string FileContainerBinutilsImpl::getArchitecture(void) throw()
    {
        if(byteorder == LITTLE)
            return "Little endian target (with GNU/Binutils)";
        else
            return "Big endian target (with GNU/Binutils)";
    }

}

//---------------------------------------------

#ifdef TESTSUITE
#include "base/coverage_undefs.h"

namespace {
    fstream * interceptor_file;
    string    interceptor_filename;
    void interceptor(fstream & file, const string & filename)
    {
        CHECKPOINT("interceptor");
        interceptor_file = &file;
        interceptor_filename = filename;

        if(filename.compare("textfile") == 0) {
            remove(filename.c_str());
            file.open(filename.c_str(), ios::out);
            file << "text";
            file.close();

            file.open(filename.c_str(), ios::in|ios::binary);
        }
        else if(filename.compare("binaryfile") == 0) {
            remove(filename.c_str());
            file.open(filename.c_str(), ios::out|ios::binary);
            file.write("\x1",1);
            file.close();

            file.open(filename.c_str(), ios::in|ios::binary);
        }
    }
}

TESTSUITE(main, FileContainerBinutilsImpl)
{
    PREDECESSOR("TFileContainer");

    SingletonBase::ContextChain chain;
    chain.saveContext<RuntimeObjectTable>();

    BEGIN_CASE("splitFilename","splitFilename") {
        BEGIN_CASE("1","ޤڤ") {
            string first, second;
            
            splitFilename("a,b", first, second);
            TEST_CASE("1","firstȤ", first.compare("a") == 0);
            TEST_CASE("2","secondȤ", second.compare("b") == 0);
        } END_CASE;

        BEGIN_CASE("2","ޤ̵ͿȡξƱȤ") {
            string first, second;

            splitFilename("abc", first, second);
            TEST_CASE("1","firstȤ", first.compare("abc") == 0);
            TEST_CASE("2","secondȤ", second.compare("abc") == 0);
        } END_CASE;

        BEGIN_CASE("3","ʸͿ㳰") {
            bool result = false;
            string first, second;
            try { splitFilename("", first, second); } catch(Exception &) { result = true; }
            if(!result)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("hasBinaryContents","hasBinaryContents") {
        BEGIN_CASE("1","ƥȥե򿩤碌") {
            fstream file("test", ios::out);
            file << "This is a sample text file.";
            file.close();

            file.open("test",ios::in|ios::binary);
            TEST_CASE("1","ؿfalse֤", !hasBinaryContents(file));
            TEST_CASE("2","fileeofãƤʤ", !file.eof());
            file.close();

            remove("test");
        } END_CASE;

        BEGIN_CASE("2","Хʥǡ򿩤碌") {
            fstream file("test", ios::out|ios::binary);
            file << "This is a sample text file.";
            file.write("\x0\x1\x2\x3", 4);
            file.close();

            file.open("test",ios::in|ios::binary);
            TEST_CASE("1","ؿtrue֤", hasBinaryContents(file));
            TEST_CASE("2","fileeofãƤʤ", !file.eof());
            file.close();

            remove("test");
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("openTextFile","openTextFile") {
        BEGIN_CASE("1","ƥȥեꤹ") {
            TestSuite::clearCheckpoints();
            fstream file("test", ios::out);
            file << "This is a sample text file.";
            file.close();

            bool result = true;
            try { openTextFile(file, "test", interceptor); } catch(Exception &) { result = false; }

            TEST_CASE("1","㳰ϵʤ", result);
            TEST_CASE("2","ե뤬Ƥ", file.is_open());
            TEST_CASE("3","interceptorϥ뤵Ƥʤ", !TestSuite::isReached("interceptor"));

            string work;
            getline(file, work, '\n');
            TEST_CASE("4","ɤ߽Ф줿Ƥ", work.compare("This is a sample text file.") == 0);

            file.close();
            remove("test");
        } END_CASE;

        BEGIN_CASE("2","Хʥեꤹ (interceptorϥե򳫤ʤ)") {
            TestSuite::clearCheckpoints();
            fstream file("test", ios::out|ios::binary);
            file.write("\x1", 1);
            file.close();

            bool result = false;
            try { openTextFile(file, "test", interceptor); } catch(Exception &) { result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","ե뤬Ƥ", !file.is_open());
            TEST_CASE("3","interceptor뤵Ƥ", TestSuite::isReached("interceptor"));
            TEST_CASE("4","interceptorΰ (file)", interceptor_file == &file);
            TEST_CASE("5","interceptorΰ", interceptor_filename.compare("test") == 0);

            file.close();
            remove("test");
        } END_CASE;

        BEGIN_CASE("3","¸ߤʤեꤹ") {
            TestSuite::clearCheckpoints();
            fstream file;
            bool result = false;
            try { openTextFile(file, "___unknown___", interceptor); } catch(Exception &) { result = true; }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","ե뤬Ƥʤ", !file.is_open());
            TEST_CASE("3","interceptor뤵Ƥʤ", !TestSuite::isReached("interceptor"));
        } END_CASE;

        BEGIN_CASE("4","interceptorƥȥե") {
            TestSuite::clearCheckpoints();
            fstream file("textfile", ios::out|ios::binary);
            file.write("\x1", 1);
            file.close();

            bool result = true;
            try { openTextFile(file, "textfile", interceptor); } catch(Exception &) { result = false; }

            TEST_CASE("1","㳰ϵʤ", result);
            TEST_CASE("2","ե뤬Ƥ", file.is_open());
            TEST_CASE("3","interceptor뤵Ƥ", TestSuite::isReached("interceptor"));
            TEST_CASE("4","interceptorΰ (file)", interceptor_file == &file);
            TEST_CASE("5","interceptorΰ", interceptor_filename.compare("textfile") == 0);

            string work;
            getline(file, work, '\n');
            TEST_CASE("4","ɤ߽Ф줿Ƥ", work.compare("text") == 0);

            file.close();
            remove("textfile");
        } END_CASE;

        BEGIN_CASE("5","interceptorХʥե") {
            TestSuite::clearCheckpoints();
            fstream file("binaryfile", ios::out|ios::binary);
            file.write("\x1", 1);
            file.close();

            bool result = false;
            try { openTextFile(file, "binaryfile", interceptor); } catch(Exception &) { result = true; }

            TEST_CASE("1","㳰ϵ", result);
            TEST_CASE("2","ե뤬Ƥʤ", !file.is_open());
            TEST_CASE("3","interceptor뤵Ƥ", TestSuite::isReached("interceptor"));
            TEST_CASE("4","interceptorΰ (file)", interceptor_file == &file);
            TEST_CASE("5","interceptorΰ", interceptor_filename.compare("binaryfile") == 0);

            file.close();
            remove("binaryfile");
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("hextodec","hextodec") {
        const char * letter = "0123456789abcdEFg";
        const char * work = letter;

        TEST_CASE("1", "ڤФ줿ͤ", hextodec(work, 2) == 1);
        TEST_CASE("2", "workʤǤ", work == letter + 2);
        TEST_CASE("3", "ڤФ줿ͤ", hextodec(work, 4) == 0x2345);
        TEST_CASE("4", "workʤǤ", work == letter + 6);
        TEST_CASE("5", "ڤФ줿ͤ", hextodec(work, 8) == 0x6789abcd);
        TEST_CASE("6", "workʤǤ", work == letter + 14);
        TEST_CASE("7", "ڤФ줿ͤ", hextodec(work, 8) == 0xef);
        TEST_CASE("8", "work'g'ΰ֤ǤȤޤ", *work == 'g');
        TEST_CASE("9", "ڤФ줿ͤ", hextodec(work, 8) == 0);
        TEST_CASE("10", "work'g'ΰ֤ǤȤޤ", *work == 'g');
    } END_CASE;

    BEGIN_CASE("readGnuNmLine","readGnuNmLine") {
        fstream file("test", ios::out);
        file << "0804aab0 T _kernel_task_initialize\n0805d8a0 B _kernel_tcb_table\n\n0804e560 R _kernel_tinib_table\n         U getpid@@GLIBC_2.0\n";
        file.close();

        address_t address;
        string    attribute;
        string    symbolname;

        file.open("test", ios::in);
        BEGIN_CASE("1","̤Υȥ꤬ɤ") {
            TEST_CASE("1","ؿ", readGnuNmLine(file, address, attribute, symbolname));
            TEST_CASE("2","address", address == 0x0804aab0);
            TEST_CASE("3","attribute", attribute.compare("T") == 0);
            TEST_CASE("4","symbolname", symbolname.compare("_kernel_task_initialize") == 0);
        } END_CASE;

        BEGIN_CASE("2","̤Υȥ꤬ɤ (2)") {
            TEST_CASE("1","ؿ", readGnuNmLine(file, address, attribute, symbolname));
            TEST_CASE("2","address", address == 0x0805d8a0);
            TEST_CASE("3","attribute", attribute.compare("B") == 0);
            TEST_CASE("4","symbolname", symbolname.compare("_kernel_tcb_table") == 0);
        } END_CASE;

        BEGIN_CASE("3","ԤɤФƼɤ") {
            TEST_CASE("1","ؿ", readGnuNmLine(file, address, attribute, symbolname));
            TEST_CASE("2","address", address == 0x0804e560);
            TEST_CASE("3","attribute", attribute.compare("R") == 0);
            TEST_CASE("4","symbolname", symbolname.compare("_kernel_tinib_table") == 0);
        } END_CASE;

        BEGIN_CASE("4","ɥ쥹̵ȥ̵뤹") {
            TEST_CASE("1","ؿϼԤ", !readGnuNmLine(file, address, attribute, symbolname));
        } END_CASE;

        file.close();
        remove("test");
    } END_CASE;

    BEGIN_CASE("loadSymbols","loadSymbols") {
        fstream file("test", ios::out);
        file << "0804aab0 T _kernel_task_initialize\n0805d8a0 B _kernel_tcb_table\n\n0804e560 R _kernel_tinib_table\n         U getpid@@GLIBC_2.0\n";
        file.close();

        file.open("test",ios::in);

        FileContainerBinutilsImpl fcbi;
        fcbi.loadSymbols(file);

        TEST_CASE("1","ɤ߹ޤ줿ȥο", fcbi.symbol_table.size() == 3);
        TEST_CASE("2","եĤƤ", !file.is_open());

        remove("test");
    } END_CASE;

    BEGIN_CASE("writeByte","writeByte") {
        FileContainerBinutilsImpl fcbi;

        BEGIN_CASE("1","¸ߤʤڡؤν񤭹") {
            TEST_CASE("0", "[] contentsǿ0", fcbi.contents.size() == 0);
            fcbi.writeByte(0x100, 0);

            TEST_CASE("1","contentsǤƤ", fcbi.contents.size() == 1);

            const char * scope = fcbi.contents.find(MAKE_BASEADDRESS(0x100))->second + MAKE_OFFSETADDRESS(0x100);
            TEST_CASE("2","񤭹ޤƤƤ", *scope == 0);
        } END_CASE;

        BEGIN_CASE("2","¸ߤڡؤν񤭹 (Ϣ³)") {
            fcbi.writeByte(0x100, 0xff);

            TEST_CASE("1","contentsǤƤʤ", fcbi.contents.size() == 1);

            const char * scope = fcbi.contents.find(MAKE_BASEADDRESS(0x100))->second + MAKE_OFFSETADDRESS(0x100);
            TEST_CASE("2","񤭹ޤƤƤ", *scope == 0xff);
        } END_CASE;

        BEGIN_CASE("3","ڡؤν񤭹") {
            fcbi.writeByte(0x10000000, 0xff);

            TEST_CASE("1","contentsǤƤ", fcbi.contents.size() == 2);

            const char * scope = fcbi.contents.find(MAKE_BASEADDRESS(0x10000000))->second + MAKE_OFFSETADDRESS(0x10000000);
            TEST_CASE("2","񤭹ޤƤƤ", *scope == 0xff);
        } END_CASE;

        BEGIN_CASE("4","¸ΥڡؤΥ") {
            fcbi.writeByte(0x100, 0x0);

            TEST_CASE("1","contentsǤƤʤ", fcbi.contents.size() == 2);

            const char * scope = fcbi.contents.find(MAKE_BASEADDRESS(0x100))->second + MAKE_OFFSETADDRESS(0x100);
            TEST_CASE("2","񤭹ޤƤƤ", *scope == 0x0);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("readRecord","readRecord") {
        fstream file("test",ios::out);
        file << "S315080480F42F6C69622F6C642D6C696E75782E736F98\n\nS315080480F42F6C69622F6C642D6C696E75782E736F98\nS308080481042E320005\nDUMMY\nS31808048108040000001000000001000000474E550056\nS31008048108040000001000000001000000474E550056\n";
        file.close();

        file.open("test",ios::in);
        BEGIN_CASE("1","辰") {
            string work;
            bool result;
            bool exception = false;
            try { result = readRecord(file, work); } catch(Exception &) { exception = true; }
            TEST_CASE("1","㳰ϵʤ", !exception);
            TEST_CASE("2","ؿtrue֤", result);
            TEST_CASE("3","ɤ߽Ф줿Ƥ", work.compare("S315080480F42F6C69622F6C642D6C696E75782E736F98") == 0);
        } END_CASE;

        BEGIN_CASE("2","辰 (ԤɤФ)") {
            string work;
            bool result;
            bool exception = false;
            try { result = readRecord(file, work); } catch(Exception &) { exception = true; }
            TEST_CASE("1","㳰ϵʤ", !exception);
            TEST_CASE("2","ؿtrue֤", result);
            TEST_CASE("3","ɤ߽Ф줿Ƥ", work.compare("S315080480F42F6C69622F6C642D6C696E75782E736F98") == 0);
        } END_CASE;

        BEGIN_CASE("3","åबäƤ륨ȥ") {
            string work;
            bool result;
            bool exception = false;
            try { result = readRecord(file, work); } catch(Exception &) { exception = true; }
            TEST_CASE("1","㳰򤪤", exception);
        } END_CASE;

        BEGIN_CASE("4","ƬSǻϤޤʤȥ") {
            string work;
            bool result;
            bool exception = false;
            try { result = readRecord(file, work); } catch(Exception &) { exception = true; }
            TEST_CASE("1","㳰򤪤", exception);
        } END_CASE;

        BEGIN_CASE("5","ꤵ줿ĹĹȥ") {
            string work;
            bool result;
            bool exception = false;
            try { result = readRecord(file, work); } catch(Exception &) { exception = true; }
            TEST_CASE("1","㳰򤪤", exception);
        } END_CASE;

        BEGIN_CASE("6","ꤵ줿Ĺûȥ") {
            string work;
            bool result;
            bool exception = false;
            try { result = readRecord(file, work); } catch(Exception &) { exception = true; }
            TEST_CASE("1","㳰򤪤", exception);
        } END_CASE;

        BEGIN_CASE("7","ե뽪ü") {
            string work;
            bool result;
            bool exception = false;
            try { result = readRecord(file, work); } catch(Exception &) { exception = true; }
            TEST_CASE("1","㳰򤪤ʤ", !exception);
            TEST_CASE("2","ؿfalse֤", !result);
        } END_CASE;

        remove("test");
    } END_CASE;

    BEGIN_CASE("chopRecord","chopRecord") {
        BEGIN_CASE("1","S1쥳") {
            string src("S106080480F42F4A");

            chopRecord(src);
            TEST_CASE("1","ͤ", src.compare("80F42F") == 0);
        } END_CASE;

        BEGIN_CASE("2","S2쥳") {
            string src("S206080480F42F4A");

            chopRecord(src);
            TEST_CASE("1","ͤ", src.compare("F42F") == 0);
        } END_CASE;

        BEGIN_CASE("3","S3쥳") {
            string src("S306080480F42F4A");

            chopRecord(src);
            TEST_CASE("1","ͤ", src.compare("2F") == 0);
        } END_CASE;

        BEGIN_CASE("4","S4쥳") {
            string src("S406080480F42F4A");

            chopRecord(src);
            TEST_CASE("1","ͤ", src.compare("080480F42F") == 0);
        } END_CASE;

        BEGIN_CASE("5","S5쥳") {
            string src("S506080480F42F4A");

            chopRecord(src);
            TEST_CASE("1","ͤ", src.compare("080480F42F") == 0);
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("loadDataContents/loadContents","loadDataContents/loadContents") {
        fstream file("test", ios::out);
        file << "S30D000000000123456789ABCDEF32\nS509FEDCBA9876543210BE";
        file.close();

        BEGIN_CASE("1","辰") {
            FileContainerBinutilsImpl fcbi;

            file.open("test",ios::in);
            bool exception = false;
            try { fcbi.loadDataContents(file); } catch(...) { exception = true; }

            TEST_CASE("1","㳰ϵʤ", !exception);
            TEST_CASE("2","ǡݤƤ", fcbi.contents.size() == 1);
            TEST_CASE("3","եĤƤ", !file.is_open());
            BEGIN_CASE("4","Ǽͤɤ") {
                unsigned int i;

                assert(sizeof(unsigned int) >= 4);
                i = 0;
                
                fcbi.loadContents(&i, 0, 4);
                TEST_CASE("1","1-4Х", i == 0x67452301);
                fcbi.loadContents(&i, 4, 4);
                TEST_CASE("1","5-8Х", i == 0xefcdab89);
                fcbi.loadContents(&i, 8, 4);
                TEST_CASE("1","9-12Х", i == 0x98badcfe);
                fcbi.loadContents(&i,12, 4);
                TEST_CASE("1","13-16Х", i == 0x10325476);
            } END_CASE;
        } END_CASE;
        remove("test");

        BEGIN_CASE("2","loadContentsǰ٤˥ڡĶ̤׵᤹") {
            FileContainerBinutilsImpl fcbi;
            unsigned int i;

            for(i=0;i<SIZE_LOADPAGE*2;++i)
                fcbi.writeByte(i, i);

            unsigned char * buffer = new unsigned char [SIZE_LOADPAGE * 2];
            fcbi.loadContents(buffer, 0, SIZE_LOADPAGE * 2);

            for(i=0;i<SIZE_LOADPAGE*2;++i)
                if(*(buffer + i) != (i & 0xff))
                    TEST_FAIL;

            delete [] buffer;
        } END_CASE;

    } END_CASE;

    BEGIN_CASE("searchSymbolPrefix","searchSymbolPrefix") {

        BEGIN_CASE("1","ץեʤ") {
            FileContainerBinutilsImpl fcbi;
            fcbi.symbol_table.insert(pair<string, address_t>(MAGIC_SYMBOL, 0x100));

            fcbi.searchSymbolPrefix();
            if(!fcbi.symbol_prefix.empty())
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ѿ̾\"_\"Ĥ") {
            FileContainerBinutilsImpl fcbi;
            fcbi.symbol_table.insert(pair<string, address_t>("_" MAGIC_SYMBOL, 0x100));

            fcbi.searchSymbolPrefix();
            if(fcbi.symbol_prefix.compare("_") != 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","\"__\"ˤȿʤ") {
            FileContainerBinutilsImpl fcbi;
            fcbi.symbol_table.insert(pair<string, address_t>("__" MAGIC_SYMBOL, 0x100));

            fcbi.searchSymbolPrefix();
            if(!fcbi.symbol_prefix.empty())
                TEST_FAIL;
        } END_CASE;
            
        BEGIN_CASE("4","ȯǤʤ硢ѹʤ") {
            FileContainerBinutilsImpl fcbi;
            fcbi.symbol_prefix.assign("test");

            fcbi.searchSymbolPrefix();
            if(fcbi.symbol_prefix.compare("test") != 0)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("searchByteOrder","searchByteOrder") {
        BEGIN_CASE("1","ۥȤƱǥ") {
            FileContainerBinutilsImpl fcbi;
            unsigned int value = MAGIC_NUMBER;
            fcbi.symbol_table.insert(pair<string, address_t>(MAGIC_SYMBOL, 0x100));

            for(int i=0;i<4;i++)
                fcbi.writeByte(0x100 + i, *((char *)&value + i));

            fcbi.byteorder = UNKNOWN;
            fcbi.searchByteOrder();

            if(fcbi.byteorder != HOSTORDER)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","ۥȤȰ㤦ǥ") {
            FileContainerBinutilsImpl fcbi;
            unsigned int value = MAGIC_NUMBER;
            fcbi.symbol_table.insert(pair<string, address_t>(MAGIC_SYMBOL, 0x100));

            for(int i=0;i<4;i++)
                fcbi.writeByte(0x100 + i, *((char *)&value + (3 - i)));

            fcbi.byteorder = UNKNOWN;
            fcbi.searchByteOrder();

            if(fcbi.byteorder == HOSTORDER)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("3","ܥ뤬̵") {
            FileContainerBinutilsImpl fcbi;
            unsigned int value = MAGIC_NUMBER;

            for(int i=0;i<4;i++)
                fcbi.writeByte(0x100 + i, *((char *)&value + (3 - i)));

            fcbi.byteorder = UNKNOWN;
            fcbi.searchByteOrder();

            if(fcbi.byteorder != UNKNOWN)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("4","ǡ̵") {
            FileContainerBinutilsImpl fcbi;
            unsigned int value = MAGIC_NUMBER;
            fcbi.symbol_table.insert(pair<string, address_t>(MAGIC_SYMBOL, 0x100));

            fcbi.byteorder = UNKNOWN;
            fcbi.searchByteOrder();

            if(fcbi.byteorder != UNKNOWN)
                TEST_FAIL;
        } END_CASE;
    } END_CASE;

    chain.restoreContext();
}

#endif /* TESTSUITE */

#endif /* FILECONTAINER_BINUTILS || TESTSUITE */

