/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003      by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣѡ
 *  ۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ǤǺۤˤϡۤȼɥȡѼԥ
 *      ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ̵
 *      ڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ǤʤǺۤˤϡΤ줫ξȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡޤ
 *      ܥեȥΥ桼ޤϥɥ桼Τʤͳ˴
 *      ᤫ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪФ
 *  ŬޤơʤݾڤԤʤޤܥեȥ
 *  ˤľŪޤϴŪʤ»˴ؤƤ⡤Ǥ
 *  ʤ
 */

/*
 *  ץåü̿Υ饤ؿXstormy16ѡ
 */

#ifndef _CPU_INSN_H_
#define _CPU_INSN_H_
#ifndef _MACRO_ONLY

/*
 *  SFWޥ
 */
#define __SFR(x) (*((volatile unsigned char*)(x)))
#define __SFRW(x) (*((volatile unsigned short*)(x)))
#define __SFR_BITSET(x,y) __SFR_BITSET_INLINE( x ,y )
#define __SFR_BITSET_INLINE(x,y) __asm__ ( "set1 " #x ",#" #y )
#define __SFR_BITCLR(x,y) __SFR_BITCLR_INLINE( x ,y )
#define __SFR_BITCLR_INLINE(x,y) __asm__ ( "clr1 " #x ",#" #y )
#define __UNLOCK_EXCP() __asm__( "set1 psw,#11" )
#define __LOCK_EXCP() __asm__( "clr1 psw,#11" )

/*
 *  PSWΤΥޥ
 */
#define __PSW ( { \
    unsigned short usPsw ; \
    __asm__( "mov %0,psw" : "=r"(usPsw) ) ; \
    usPsw ; \
} )

#endif /* _MACRO_ONLY */
#endif /* _CPU_INSN_H_ */
